/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import hmi.bml.BMLElement;
import hmi.bml.Description;
import hmi.bml.SyncPoint;
import hmi.bml.parser.BMLParser;
import hmi.bml.parser.Timing;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Behaviour
extends BMLElement {
    private ArrayList<SyncPoint> syncPoints = new ArrayList();
    private ArrayList<Description> descriptions = new ArrayList();
    private SyncPoint start;
    public Behaviour descBehaviour = null;
    private int descPriority = 0;
    public Timing timing;
    public float timeOffset;

    public Behaviour() {
        this.addDefaultSyncPoints();
    }

    public abstract float getFloatParameterValue(String var1);

    public abstract String getStringParameterValue(String var1);

    public abstract boolean specifiesParameter(String var1);

    public boolean satisfiesConstraint(String name, String value) {
        return false;
    }

    public SyncPoint getStartSyncPoint() {
        return this.start;
    }

    public void addDefaultSyncPoints() {
        this.start = new SyncPoint(this, "start");
        this.addSyncPoint(this.start);
        this.addSyncPoint(new SyncPoint(this, "ready"));
        this.addSyncPoint(new SyncPoint(this, "stroke-start"));
        this.addSyncPoint(new SyncPoint(this, "stroke"));
        this.addSyncPoint(new SyncPoint(this, "stroke-end"));
        this.addSyncPoint(new SyncPoint(this, "relax"));
        this.addSyncPoint(new SyncPoint(this, "end"));
    }

    public void addSyncPoint(SyncPoint syncPoint) {
        this.syncPoints.add(syncPoint);
    }

    public void removeSyncPoints(List<SyncPoint> points) {
        this.syncPoints.removeAll(points);
    }

    public void addSyncPoints(List<SyncPoint> points) {
        this.syncPoints.addAll(points);
    }

    public ArrayList<SyncPoint> getSyncPoints() {
        return this.syncPoints;
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        for (SyncPoint s : this.syncPoints) {
            String ref;
            if (s.getIteration() != -1 || (ref = s.getRefString()) == "") continue;
            Behaviour.appendAttribute((StringBuilder)buf, (String)s.getName(), (String)ref);
        }
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        for (SyncPoint s : this.syncPoints) {
            String ref = this.getOptionalAttribute(s.getName(), attrMap);
            if (ref == null) continue;
            s.setRefString(ref);
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Behaviour.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.descriptions);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Description.xmlTag())) {
                Description d = new Description();
                d.readXML(tokenizer);
                if (d.isParsed && d.priority > this.descPriority) {
                    this.descPriority = d.priority;
                    this.descBehaviour = d.behaviour;
                    this.descBehaviour.id = this.id;
                    this.descBehaviour.bmlId = this.bmlId;
                    this.descBehaviour.fullId = this.fullId;
                }
                this.descriptions.add(d);
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    public boolean hasContent() {
        return this.descriptions.size() > 0;
    }

    public void schedule(BMLParser scheduler) {
        scheduler.schedule(this);
    }

    public void outputTimeline() {
        System.out.println(String.format("%-15s", this.fullId) + new Timeline(this));
    }

    public void constructConstraints(String bbId, BMLParser scheduler) {
        scheduler.constructConstraints(bbId, this);
    }

    private static class Timeline {
        private int dotsPerSecond = 20;
        private Behaviour behaviour;
        private int suppressDots;

        public Timeline(Behaviour behaviour) {
            this.behaviour = behaviour;
        }

        private String getDots(float time) {
            int nrDots = Math.round(time * (float)this.dotsPerSecond);
            if (nrDots > this.suppressDots) {
                nrDots -= this.suppressDots;
                this.suppressDots = 0;
            }
            if (nrDots == this.suppressDots) {
                nrDots = 0;
                this.suppressDots = 0;
            }
            if (nrDots < this.suppressDots) {
                nrDots = 0;
                this.suppressDots -= nrDots;
            }
            StringBuffer dots = new StringBuffer();
            for (int i = 0; i < nrDots; ++i) {
                dots.append('.');
            }
            return dots.toString();
        }

        private String allocateString(String string) {
            this.suppressDots += string.length();
            return string;
        }

        public String toString() {
            return null;
        }
    }
}

