/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum BMLSync {
    START("start"),
    READY("ready"),
    STROKE_START("stroke-start"),
    STROKE("stroke"),
    STROKE_END("stroke-end"),
    RELAX("relax"),
    END("end");

    private String id;
    private static Map<String, BMLSync> idToSync;

    public boolean isBefore(BMLSync s) {
        return this.ordinal() < s.ordinal();
    }

    public boolean isAfter(BMLSync s) {
        return this.ordinal() > s.ordinal();
    }

    private BMLSync(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static BMLSync get(String id) {
        return idToSync.get(id);
    }

    static {
        idToSync = new HashMap<String, BMLSync>();
        for (BMLSync bs : EnumSet.allOf(BMLSync.class)) {
            idToSync.put(bs.getId(), bs);
        }
    }
}

