/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import hmi.bml.parser.BMLParser;
import hmi.bml.parser.Breadcrumb;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public class BMLElement
extends XMLStructureAdapter {
    public String id;
    public String fullId;
    public String bmlId;
    private static final String XMLTAG = "BMLStructureAdapter";
    private int prevLine = -1;
    private int prevChar = -1;

    public StringBuilder appendAttributeString(StringBuilder buf) {
        BMLElement.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        return buf;
    }

    public String takeRawContent(XMLTokenizer tokenizer, String tagname) throws IOException {
        StringBuffer buf = new StringBuffer();
        try {
            boolean alert = false;
            String history = "";
            Reader reader = tokenizer.getReader();
            while (true) {
                if (!alert) {
                    reader.mark(0);
                }
                char c = (char)reader.read();
                buf.append(c);
                if (!alert) {
                    if (c != '<') continue;
                    alert = true;
                    history = "<";
                    continue;
                }
                if ((history = history + c).equals("</" + tagname + ">")) {
                    reader.reset();
                    break;
                }
                if (c != '>') continue;
                alert = false;
                history = "";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buf.delete(buf.length() - tagname.length() - 3, buf.length());
        return buf.toString();
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.id = this.getRequiredAttribute("id", attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public void registerElementsById(BMLParser scheduler, Breadcrumb breadcrumb) {
        scheduler.registerBMLElement(this, breadcrumb);
    }

    protected void ensureDecodeProgress(XMLTokenizer tokenizer) {
        int curLine = tokenizer.getLine();
        int curChar = tokenizer.getCharPos();
        if (curLine == this.prevLine && curChar == this.prevChar) {
            throw new RuntimeException("Loop detected, no valid BML. Possibly, a STag was encountered that cannot be parsed. Line: " + curLine + ", char: " + curChar);
        }
        this.prevLine = curLine;
        this.prevChar = curChar;
    }
}

