// Generated by delombok at Fri Aug 07 09:29:55 CEST 2015
/*******************************************************************************
 * The MIT License (MIT)
 * Copyright (c) 2015 University of Twente
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *******************************************************************************/
package hmi.animationui;

import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

/**
 * A user interface to set and update ik positions
 *
 * @author hvanwelbergen
 */
public class IKView {
    private JPanel panel = new JPanel();
    
    public IKView(List<AnalyticalIKController> controllers) {
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        for (AnalyticalIKController c : controllers) {
            IKPanel ikPanel = new IKPanel(c.getId(), c, c.getStartPos(), c.getStartSwivel());
            panel.add(ikPanel.getPanel());
        }
        panel.add(Box.createVerticalGlue());
    }
    
    @java.lang.SuppressWarnings("all")
    public JPanel getPanel() {
        return this.panel;
    }
}