/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.util.Console;
import java.util.ArrayList;
import java.util.List;

public class VObjectTransformCopier {
    private final VObject[] srcParts;
    private final VObject[] dstParts;
    private String configType;
    private boolean hasRootTranslation;
    private boolean hasTranslation;
    private boolean hasRotation;
    private boolean hasScale;
    private boolean hasVelocity;
    private boolean hasAngularVelocity;
    private float[] buf = new float[4];
    private static final VObject[] emptyParts = new VObject[0];

    protected VObjectTransformCopier(VObject[] srcParts, VObject[] dstParts, String type) {
        this.srcParts = srcParts;
        this.dstParts = dstParts;
        this.setConfigType(type);
    }

    public static <T extends VObject> VObjectTransformCopier newInstanceFromMatchingVObjectLists(List<T> srcList, List<T> dstList, String type) {
        ArrayList<T> selectedSrcList = new ArrayList<T>(srcList.size());
        ArrayList<T> selectedDstList = new ArrayList<T>(srcList.size());
        for (int i = 0; i < srcList.size(); ++i) {
            selectedSrcList.add(srcList.get(i));
            selectedDstList.add(dstList.get(i));
        }
        VObject[] srcParts = selectedSrcList.toArray(emptyParts);
        VObject[] dstParts = selectedDstList.toArray(emptyParts);
        return new VObjectTransformCopier(srcParts, dstParts, type);
    }

    public static <T extends VObject> VObjectTransformCopier newInstanceFromVObjectLists(List<T> srcList, List<T> dstList, String type) {
        ArrayList<VObject> selectedSrcList = new ArrayList<VObject>(srcList.size());
        ArrayList<VObject> selectedDstList = new ArrayList<VObject>(srcList.size());
        block0: for (VObject srcObject : srcList) {
            for (VObject dstObject : dstList) {
                if (!VObjectTransformCopier.equiv(srcObject, dstObject)) continue;
                selectedSrcList.add(srcObject);
                selectedDstList.add(dstObject);
                continue block0;
            }
        }
        VObject[] srcParts = selectedSrcList.toArray(emptyParts);
        VObject[] dstParts = selectedDstList.toArray(emptyParts);
        return new VObjectTransformCopier(srcParts, dstParts, type);
    }

    public static VObjectTransformCopier newInstanceFromVJointTree(VJoint sourceRoot, VJoint destinationRoot, String type) {
        return VObjectTransformCopier.newInstanceFromVObjectLists(sourceRoot.getParts(), destinationRoot.getParts(), type);
    }

    private static boolean equiv(VObject src, VObject dst) {
        return src.getId() != null && src.getId().equals(dst.getId()) || src.getSid() != null && src.getSid().equals(dst.getSid()) || src.getName() != null && src.getName().equals(dst.getName());
    }

    public void setConfigType(String configType) {
        this.configType = configType;
        this.hasRootTranslation = configType.startsWith("T1");
        if (!this.hasRootTranslation) {
            this.hasTranslation = configType.indexOf(84) >= 0;
        }
        this.hasRotation = configType.indexOf(82) >= 0;
        this.hasScale = configType.indexOf(83) >= 0;
        this.hasVelocity = configType.indexOf(86) >= 0;
        this.hasAngularVelocity = configType.indexOf(87) >= 0;
    }

    public void copyConfig() {
        int i;
        if (this.srcParts == null || this.dstParts == null) {
            Console.println((String)"VObjectTreeCopier.copyConfig: null source or destination");
            return;
        }
        if (this.hasRootTranslation) {
            this.srcParts[0].getTranslation(this.buf);
            this.dstParts[0].setTranslation(this.buf);
        }
        if (this.hasTranslation) {
            for (i = 0; i < this.srcParts.length; ++i) {
                this.srcParts[i].getTranslation(this.buf);
                this.dstParts[i].setTranslation(this.buf);
            }
        }
        if (this.hasRotation) {
            for (i = 0; i < this.srcParts.length; ++i) {
                this.srcParts[i].getRotation(this.buf);
                this.dstParts[i].setRotation(this.buf);
            }
        }
        if (this.hasScale) {
            for (i = 0; i < this.srcParts.length; ++i) {
                this.srcParts[i].getScale(this.buf);
                this.dstParts[i].setScale(this.buf);
            }
        }
        if (this.hasVelocity) {
            for (i = 0; i < this.srcParts.length; ++i) {
                this.srcParts[i].getVelocity(this.buf);
                this.dstParts[i].setVelocity(this.buf);
            }
        }
        if (this.hasAngularVelocity) {
            for (i = 0; i < this.srcParts.length; ++i) {
                this.srcParts[i].getAngularVelocity(this.buf);
                this.dstParts[i].setAngularVelocity(this.buf);
            }
        }
    }

    public String getConfigType() {
        return this.configType;
    }
}

