/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.VJoint;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.util.ClockListener;
import hmi.util.KeyState;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class VJointMoveControl
implements ClockListener {
    private VJoint theVJoint;
    private KeyState keyState;
    private float inversionFactor = 1.0f;
    private List<Integer> theKeyModifiers = null;
    private boolean bListening = true;
    private boolean useLimits = false;
    private float minX = -1.0f;
    private float minY = -1.0f;
    private float minZ = -1.0f;
    private float maxX = 1.0f;
    private float maxY = 1.0f;
    private float maxZ = 1.0f;
    double currentDoubleTime;
    double lastTime;
    float[] position = new float[3];
    float[] orientation = new float[3];
    private float[] rotation = new float[4];
    private float[] translation = new float[3];
    private float[] transformMatrix = new float[16];
    private float[] rotationMatrix = new float[16];
    private float[] translationMatrix = new float[16];
    float linVel;
    float vertVel;
    float strafeVel;
    float angVel;
    public static final double degToRad = Math.PI / 180;
    private static final float conv = (float)Math.PI / 180;

    public VJointMoveControl(Component c, VJoint joint, boolean invert, int[] keyModifiers, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this(c, joint, invert, keyModifiers);
        this.setLimits(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void setLimits(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.useLimits = true;
    }

    public VJointMoveControl(Component c, VJoint joint, boolean invert, int[] keyModifiers) {
        this.keyState = new KeyState(c);
        this.theVJoint = joint;
        if (!invert) {
            this.inversionFactor = -1.0f;
        }
        this.theKeyModifiers = new ArrayList<Integer>();
        for (int i = 0; i < keyModifiers.length; ++i) {
            this.theKeyModifiers.add(keyModifiers[i]);
        }
        Mat4f.setIdentity((float[])this.rotationMatrix);
        Mat4f.setIdentity((float[])this.translationMatrix);
        Mat4f.setIdentity((float[])this.transformMatrix);
        this.linVel = 1.0f;
        this.vertVel = 1.0f;
        this.strafeVel = 1.0f;
        this.angVel = 50.0f;
    }

    public void setVJoint(VJoint newVJoint) {
        this.theVJoint = newVJoint;
    }

    public void setPosition(float[] pos) {
        this.position[0] = this.inversionFactor * pos[0];
        this.position[1] = this.inversionFactor * pos[1];
        this.position[2] = this.inversionFactor * pos[2];
    }

    public void setPosition(float x, float y, float z) {
        this.position[0] = this.inversionFactor * x;
        this.position[1] = this.inversionFactor * y;
        this.position[2] = this.inversionFactor * z;
    }

    public void setOrientation(float xrot, float yrot, float zrot) {
        this.orientation[0] = xrot;
        this.orientation[1] = -yrot;
        this.orientation[2] = zrot;
    }

    public void setRollPitchYaw(float roll, float pitch, float yaw) {
        Quat4f.setFromEulerAngles((float[])this.rotation, (float)(yaw * ((float)Math.PI / 180)), (float)(pitch * ((float)Math.PI / 180)), (float)(roll * ((float)Math.PI / 180)));
    }

    public void setTranslation(float tx, float ty, float tz) {
        this.translation[0] = tx;
        this.translation[1] = ty;
        this.translation[2] = tz;
    }

    public void setListening(boolean l) {
        this.bListening = l;
    }

    protected void applyLimits() {
    }

    private boolean correctModifiers(KeyState keyState) {
        if (this.theKeyModifiers.contains(17) != keyState.isKeyDown(17)) {
            return false;
        }
        if (this.theKeyModifiers.contains(18) != keyState.isKeyDown(18)) {
            return false;
        }
        return this.theKeyModifiers.contains(16) == keyState.isKeyDown(16);
    }

    public void initTime(double time) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(double currentTime) {
        if (!this.bListening) {
            return;
        }
        this.currentDoubleTime = currentTime;
        float linearVelocity = 0.0f;
        float vertVelocity = 0.0f;
        float strafeVelocity = 0.0f;
        float angularVelocityY = 0.0f;
        float angularVelocityX = 0.0f;
        KeyState keyState = this.keyState;
        synchronized (keyState) {
            if (this.keyState.isKeyDown(38) && this.correctModifiers(this.keyState)) {
                linearVelocity = this.inversionFactor * this.linVel;
            }
            if (this.keyState.isKeyDown(87) && this.correctModifiers(this.keyState)) {
                linearVelocity = this.inversionFactor * 3.0f * this.linVel;
            }
            if (this.keyState.isKeyDown(40) && this.correctModifiers(this.keyState)) {
                linearVelocity = this.inversionFactor * -this.linVel;
            }
            if (this.keyState.isKeyDown(83) && this.correctModifiers(this.keyState)) {
                linearVelocity = this.inversionFactor * -3.0f * this.linVel;
            }
            if (this.keyState.isKeyDown(37) && this.correctModifiers(this.keyState)) {
                angularVelocityY = this.inversionFactor * this.angVel;
            }
            if (this.keyState.isKeyDown(65) && this.correctModifiers(this.keyState)) {
                strafeVelocity = this.inversionFactor * -4.0f * this.strafeVel;
            }
            if (this.keyState.isKeyDown(39) && this.correctModifiers(this.keyState)) {
                angularVelocityY = this.inversionFactor * -this.angVel;
            }
            if (this.keyState.isKeyDown(68) && this.correctModifiers(this.keyState)) {
                strafeVelocity = this.inversionFactor * 4.0f * this.strafeVel;
            }
            if (this.keyState.isKeyDown(33) && this.correctModifiers(this.keyState)) {
                vertVelocity = this.inversionFactor * this.vertVel;
            }
            if (this.keyState.isKeyDown(34) && this.correctModifiers(this.keyState)) {
                vertVelocity = this.inversionFactor * -this.vertVel;
            }
        }
        float delta = (float)(this.currentDoubleTime - this.lastTime);
        this.lastTime = this.currentDoubleTime;
        float angle = this.orientation[0] + delta * angularVelocityX;
        if (angle >= 360.0f) {
            angle -= 360.0f;
        }
        if (angle <= -360.0f) {
            angle += 360.0f;
        }
        this.orientation[0] = angle;
        angle = this.orientation[1] + delta * angularVelocityY;
        if (angle >= 360.0f) {
            angle -= 360.0f;
        }
        if (angle <= -360.0f) {
            angle += 360.0f;
        }
        this.orientation[1] = angle;
        double radAngle = Math.PI / 180 * (double)this.orientation[1];
        float deltalinx = -delta * linearVelocity * (float)Math.sin(radAngle);
        this.position[0] = this.position[0] + deltalinx;
        float deltalinz = -delta * linearVelocity * (float)Math.cos(radAngle);
        this.position[2] = this.position[2] + deltalinz;
        float deltax = delta * strafeVelocity * (float)Math.cos(radAngle);
        this.position[0] = this.position[0] + deltax;
        this.position[2] = this.position[2] - delta * strafeVelocity * (float)Math.sin(radAngle);
        this.position[1] = this.position[1] + delta * vertVelocity;
        if (this.useLimits) {
            this.applyLimits();
        }
        this.setRollPitchYaw(-this.orientation[2], -this.orientation[0], -this.orientation[1]);
        this.setTranslation(-this.position[0], -this.position[1], -this.position[2]);
        Mat4f.setRotation((float[])this.rotationMatrix, (float[])this.rotation);
        Mat4f.setTranslation((float[])this.translationMatrix, (float[])this.translation);
        Mat4f.mul((float[])this.transformMatrix, (float[])this.rotationMatrix, (float[])this.translationMatrix);
        Quat4f.transformVec3f((float[])this.rotation, (float[])this.translation);
        if (this.theVJoint != null) {
            this.theVJoint.setTranslation(this.translation);
            this.theVJoint.setRotation(this.rotation);
        }
    }
}

