/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.VJoint;
import hmi.math.Mat3f;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;

public class AnalyticalIKSolver {
    private float[] Sv = new float[3];
    private float[] Tv = new float[3];
    private float[] WH = new float[3];
    private float[] Rx = new float[16];
    private float[] R1 = new float[16];
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private double swivel = 1.5707963267948966;
    private float projectionLength = 0.0f;
    private boolean project = false;
    private float[] sewT = new float[16];
    private float R = 1.0f;
    private float elbowStartRotation = 0.0f;
    private float[] C = new float[3];
    private float[] goal = new float[3];
    private float[] a = new float[3];
    private float[] elbowRotAxis = new float[3];
    private LimbPosition limbPosition = LimbPosition.ARM;
    private static final double ROT_MARGIN = 0.05;
    private static final double DOT_MARGIN = 0.05;
    float l1;
    float l2;
    private float[] x = new float[3];
    private float[] y = new float[3];
    private float[] z = new float[3];
    private float[] w = new float[3];
    private float[] n = new float[3];
    private float[] e = new float[3];
    private float[] tempv = new float[3];
    private float[] forward = new float[3];
    private float[] axis = new float[3];
    private float[] backAxis = new float[3];
    private float[] planeNormal = new float[3];
    private float[] aRot = new float[9];
    private float[] eNorm = new float[3];
    private float[] u = new float[3];
    private float[] v = new float[3];

    public AnalyticalIKSolver(float[] sv, float[] tv, LimbPosition lp) {
        this.limbPosition = lp;
        Vec3f.set((float[])this.Sv, (float[])sv);
        Vec3f.set((float[])this.Tv, (float[])tv);
        this.swivel = 0.0;
        this.project = false;
        Vec3f.set((float[])this.WH, (float[])tv);
        Vec3f.add((float[])this.WH, (float[])sv);
        this.l1 = Vec3f.length((float[])tv);
        this.l2 = Vec3f.length((float[])sv);
        double l3 = Vec3f.length((float[])this.WH);
        Vec3f.set((float[])this.e, (float[])tv);
        this.elbowStartRotation = (double)(this.l1 + this.l2) > l3 ? (float)Math.acos(((double)(this.l1 * this.l1 + this.l2 * this.l2) - l3 * l3) / (double)(2.0f * this.l1 * this.l2)) : (float)Math.PI;
        if (Math.abs((double)this.elbowStartRotation - Math.PI) <= 0.05) {
            if (this.limbPosition == LimbPosition.ARM) {
                Vec3f.set((float[])this.elbowRotAxis, (float)1.0f, (float)0.0f, (float)0.0f);
            } else if (this.limbPosition == LimbPosition.LEG) {
                Vec3f.set((float[])this.elbowRotAxis, (float)-1.0f, (float)0.0f, (float)0.0f);
            }
        } else {
            Vec3f.cross((float[])this.elbowRotAxis, (float[])sv, (float[])tv);
            Vec3f.normalize((float[])this.elbowRotAxis);
        }
        Vec3f.set((float[])this.x, (float[])this.e);
        Vec3f.scale((float)-1.0f, (float[])this.x);
        Vec3f.normalize((float[])this.x);
        Vec3f.set((float[])this.w, (float[])this.WH);
        Vec3f.normalize((float[])this.w);
        Vec3f.set((float[])this.y, (float[])this.w);
        float dot = Vec3f.dot((float[])this.w, (float[])this.x);
        if (Math.abs(Math.acos(dot) - Math.PI) > 0.05) {
            Vec3f.set((float[])this.tempv, (float[])this.x);
            Vec3f.scale((float)dot, (float[])this.tempv);
            Vec3f.sub((float[])this.y, (float[])this.tempv);
            Vec3f.normalize((float[])this.y);
            Vec3f.cross((float[])this.z, (float[])this.x, (float[])this.y);
            Mat4f.set((float[])this.sewT, (float)this.x[0], (float)this.y[0], (float)this.z[0], (float)0.0f, (float)this.x[1], (float)this.y[1], (float)this.z[1], (float)0.0f, (float)this.x[2], (float)this.y[2], (float)this.z[2], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (this.limbPosition == LimbPosition.ARM) {
            Mat4f.set((float[])this.sewT, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (this.limbPosition == LimbPosition.LEG) {
            Mat4f.set((float[])this.sewT, (float)0.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        Mat4f.transpose((float[])this.sewT);
    }

    public AnalyticalIKSolver(float[] sv, float[] tv, LimbPosition limbPosition, float projectionLength) {
        this(sv, tv, limbPosition);
        this.project = true;
        this.projectionLength = projectionLength;
    }

    public void setSwivel(double swivel) {
        this.swivel = swivel;
    }

    public void solve(float[] goal, float[] qSho, float[] qElb) {
        this.solveIt(goal);
        Quat4f.setFromMat4f((float[])qSho, (float[])this.getR1());
        Quat4f.setFromMat4f((float[])qElb, (float[])this.getRx());
    }

    public double getSwivel(float[] e, float[] g) {
        double rem;
        double sw = 0.0;
        Vec3f.set((float[])this.goal, (float[])g);
        Vec3f.normalize((float[])this.n, (float[])this.goal);
        if (this.limbPosition == LimbPosition.ARM) {
            Vec3f.set((float[])this.forward, (float)g[0], (float)0.0f, (float)g[2]);
            rem = g[1];
            Vec3f.set((float[])this.axis, (float)0.0f, (float)-1.0f, (float)0.0f);
            Vec3f.set((float[])this.backAxis, (float)0.0f, (float)0.0f, (float)-1.0f);
        } else {
            Vec3f.set((float[])this.forward, (float)g[0], (float)g[1], (float)0.0f);
            rem = g[2];
            Vec3f.set((float[])this.axis, (float)0.0f, (float)0.0f, (float)1.0f);
            Vec3f.set((float[])this.backAxis, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rem * rem < 1.0E-7) {
            Vec3f.set((float[])this.a, (float[])this.axis);
        } else if ((double)Vec3f.length((float[])this.forward) < 1.0E-5) {
            Vec3f.set((float[])this.a, (float[])this.backAxis);
        } else {
            Vec3f.cross((float[])this.planeNormal, (float[])g, (float[])this.forward);
            Vec3f.normalize((float[])this.planeNormal);
            double rotAngle = this.limbPosition == LimbPosition.ARM ? (g[1] < 0.0f ? -1.5707963267948966 : 1.5707963267948966) : (g[2] < 0.0f ? 1.5707963267948966 : -1.5707963267948966);
            Mat3f.setFromAxisAngleScale((float[])this.aRot, (float[])this.planeNormal, (float)((float)rotAngle), (float)1.0f);
            Vec3f.set((float[])this.a, (float[])this.n);
            Mat3f.transformVec3f((float[])this.aRot, (float[])this.a);
        }
        float l3 = Vec3f.length((float[])this.goal);
        if (this.project && l3 > this.projectionLength) {
            l3 = this.projectionLength;
            Vec3f.set((float[])this.goal, (float[])this.n);
            Vec3f.scale((float)l3, (float[])this.goal);
        }
        float cosAlpha = (l3 * l3 + this.l1 * this.l1 - this.l2 * this.l2) / (2.0f * l3 * this.l1);
        Vec3f.set((float[])this.C, (float[])this.n);
        Vec3f.scale((float)(cosAlpha * this.l1), (float[])this.C);
        Vec3f.set((float[])this.u, (float[])this.a);
        Vec3f.set((float[])this.eNorm, (float[])e);
        Vec3f.sub((float[])this.eNorm, (float[])this.C);
        Vec3f.normalize((float[])this.eNorm);
        sw = Math.acos(Vec3f.dot((float[])this.eNorm, (float[])this.u));
        return sw;
    }

    public boolean solveIt(float[] g) {
        double rem;
        double swiv = this.swivel;
        Vec3f.set((float[])this.goal, (float[])g);
        Vec3f.normalize((float[])this.n, (float[])this.goal);
        if (this.limbPosition == LimbPosition.ARM) {
            Vec3f.set((float[])this.forward, (float)g[0], (float)0.0f, (float)g[2]);
            rem = g[1];
            Vec3f.set((float[])this.axis, (float)0.0f, (float)-1.0f, (float)0.0f);
            Vec3f.set((float[])this.backAxis, (float)0.0f, (float)0.0f, (float)-1.0f);
        } else {
            Vec3f.set((float[])this.forward, (float)g[0], (float)g[1], (float)0.0f);
            rem = g[2];
            Vec3f.set((float[])this.axis, (float)0.0f, (float)0.0f, (float)1.0f);
            Vec3f.set((float[])this.backAxis, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rem * rem < 1.0E-7) {
            Vec3f.set((float[])this.a, (float[])this.axis);
        } else if ((double)Vec3f.length((float[])this.forward) < 1.0E-5) {
            Vec3f.set((float[])this.a, (float[])this.backAxis);
        } else {
            Vec3f.cross((float[])this.planeNormal, (float[])g, (float[])this.forward);
            Vec3f.normalize((float[])this.planeNormal);
            double rotAngle = this.limbPosition == LimbPosition.ARM ? (g[1] < 0.0f ? -1.5707963267948966 : 1.5707963267948966) : (g[2] < 0.0f ? 1.5707963267948966 : -1.5707963267948966);
            Mat3f.setFromAxisAngleScale((float[])this.aRot, (float[])this.planeNormal, (float)((float)rotAngle), (float)1.0f);
            Vec3f.set((float[])this.a, (float[])this.n);
            Mat3f.transformVec3f((float[])this.aRot, (float[])this.a);
        }
        float l3 = Vec3f.length((float[])this.goal);
        if (this.project && l3 > this.projectionLength) {
            l3 = this.projectionLength;
            Vec3f.set((float[])this.goal, (float[])this.n);
            Vec3f.scale((float)l3, (float[])this.goal);
        }
        if (this.solveRy(this.l1, this.l2, l3)) {
            float cosAlpha = (l3 * l3 + this.l1 * this.l1 - this.l2 * this.l2) / (2.0f * l3 * this.l1);
            float sinAlpha = (float)Math.sqrt(1.0f - cosAlpha * cosAlpha);
            Vec3f.set((float[])this.C, (float[])this.n);
            Vec3f.scale((float)(cosAlpha * this.l1), (float[])this.C);
            Vec3f.set((float[])this.u, (float[])this.a);
            Vec3f.cross((float[])this.v, (float[])this.u, (float[])this.n);
            this.R = this.l1 * sinAlpha;
            Vec3f.set((float[])this.e, (float[])this.u);
            Vec3f.scale((float)((float)Math.cos(swiv)), (float[])this.e);
            Vec3f.set((float[])this.tempv, (float[])this.v);
            Vec3f.scale((float)((float)Math.sin(swiv)), (float[])this.tempv);
            Vec3f.add((float[])this.e, (float[])this.tempv);
            Vec3f.normalize((float[])this.e);
            Vec3f.scale((float)this.R, (float[])this.e);
            Vec3f.add((float[])this.e, (float[])this.C);
            Vec3f.set((float[])this.x, (float[])this.e);
            Vec3f.scale((float)-1.0f, (float[])this.x);
            Vec3f.normalize((float[])this.x);
            Vec3f.set((float[])this.w, (float[])this.goal);
            Vec3f.normalize((float[])this.w);
            Vec3f.set((float[])this.y, (float[])this.w);
            float dot = Vec3f.dot((float[])this.w, (float[])this.x);
            Vec3f.set((float[])this.tempv, (float[])this.x);
            Vec3f.scale((float)dot, (float[])this.tempv);
            Vec3f.sub((float[])this.y, (float[])this.tempv);
            Vec3f.normalize((float[])this.y);
            Vec3f.cross((float[])this.z, (float[])this.x, (float[])this.y);
            Mat4f.set((float[])this.R1, (float)this.x[0], (float)this.y[0], (float)this.z[0], (float)0.0f, (float)this.x[1], (float)this.y[1], (float)this.z[1], (float)0.0f, (float)this.x[2], (float)this.y[2], (float)this.z[2], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Mat4f.mul((float[])this.R1, (float[])this.R1, (float[])this.sewT);
            return true;
        }
        Mat4f.setIdentity((float[])this.Rx);
        Vec3f.set((float[])this.y, (float[])this.n);
        Vec3f.scale((float)-1.0f, (float[])this.y);
        Vec3f.set((float[])this.w, (float)1.0f, (float)0.0f, (float)0.0f);
        Vec3f.set((float[])this.x, (float)1.0f, (float)0.0f, (float)0.0f);
        float dot = Vec3f.dot((float[])this.w, (float[])this.y);
        Vec3f.set((float[])this.tempv, (float[])this.y);
        Vec3f.scale((float)dot, (float[])this.tempv);
        Vec3f.sub((float[])this.x, (float[])this.tempv);
        Vec3f.normalize((float[])this.x);
        Vec3f.cross((float[])this.z, (float[])this.x, (float[])this.y);
        Mat4f.set((float[])this.R1, (float)this.x[0], (float)this.y[0], (float)this.z[0], (float)0.0f, (float)this.x[1], (float)this.y[1], (float)this.z[1], (float)0.0f, (float)this.x[2], (float)this.y[2], (float)this.z[2], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Mat4f.mul((float[])this.R1, (float[])this.R1, (float[])this.sewT);
        return false;
    }

    private boolean solveRy(double l1, double l2, double l3) {
        if (l1 + l2 >= l3) {
            double cosAlpha = (l1 * l1 + l2 * l2 - l3 * l3) / (2.0 * l1 * l2);
            float alpha = this.elbowStartRotation - (float)Math.acos(cosAlpha);
            Mat4f.setIdentity((float[])this.Rx);
            Mat4f.setRotationFromAxisAngle((float[])this.Rx, (float[])this.elbowRotAxis, (float)(-alpha));
            return true;
        }
        return false;
    }

    public float[] getR1() {
        return this.R1;
    }

    public float[] getRx() {
        return this.Rx;
    }

    public float[] getC() {
        return this.C;
    }

    public double getR() {
        return this.R;
    }

    public float[] getA() {
        return this.a;
    }

    public void setProject(boolean proj) {
        this.project = proj;
    }

    public void setProjectionLength(float length) {
        this.projectionLength = length;
    }

    public static void translateToLocalSystem(VJoint obj1, VJoint obj2, float[] src, float[] dst) {
        float[] q = new float[4];
        obj2.getParent().getPathRotation(obj1, q);
        float[] v = new float[3];
        obj2.getPathTranslation(obj1, v);
        float s = 1.0f;
        float[] m = new float[16];
        Mat4f.setFromTRS((float[])m, (float[])v, (float[])q, (float)s);
        Mat4f.invertRigid((float[])m);
        Mat4f.transformPoint((float[])m, (float[])dst, (float[])src);
    }

    public static enum LimbPosition {
        ARM,
        LEG;

    }
}

