/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.VObject;
import hmi.math.Quat4f;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkeletonPose
extends XMLStructureAdapter {
    private static final String[] empty_PartIds = new String[0];
    private String[] partIds = empty_PartIds;
    private float[] config;
    private String configType;
    private int configSize;
    private int stride;
    private boolean hasRootTranslation;
    private boolean hasTranslation;
    private boolean hasRotation;
    private boolean hasScale;
    private boolean hasVelocity;
    private boolean hasAngularVelocity;
    private String rotationEncoding = null;
    private VObject[] targetParts;
    private static Logger logger = LoggerFactory.getLogger((String)SkeletonPose.class.getName());
    private static final String XMLTAG = "SkeletonPose";

    public SkeletonPose(XMLTokenizer tokenizer) throws IOException {
        this.readXML(tokenizer);
    }

    public SkeletonPose(String[] partIds, float[] config, String configType) {
        this.setPartIds(partIds);
        this.setConfig(config);
        this.setConfigType(configType);
        this.calculateConfigSize();
    }

    public SkeletonPose(String[] partIds, String configType) {
        this.setPartIds(partIds);
        this.setConfigType(configType);
        this.calculateConfigSize();
        this.config = new float[this.configSize];
        this.setConfig(this.config);
    }

    public SkeletonPose(VObject[] targets, String configType) {
        this.targetParts = targets;
        this.setPartIds(targets);
        this.setConfigType(configType);
        this.calculateConfigSize();
        this.config = new float[this.configSize];
        this.setConfig(this.config);
    }

    public void setPartIds(VObject[] targets) {
        this.partIds = new String[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            this.partIds[i] = targets[i].getId();
        }
    }

    private void calculateConfigSize() {
        this.stride = 0;
        if (this.hasTranslation) {
            this.stride += 3;
        }
        if (this.hasRotation) {
            this.stride += 4;
        }
        if (this.hasScale) {
            this.stride += 3;
        }
        if (this.hasVelocity) {
            this.stride += 3;
        }
        if (this.hasAngularVelocity) {
            this.stride += 3;
        }
        this.configSize = this.stride * this.partIds.length;
        if (this.hasRootTranslation) {
            this.configSize += 3;
        }
    }

    public void setConfig(float[] config) {
        this.config = config;
    }

    public float[] getConfig() {
        return this.config;
    }

    public void setPartIds(String[] partIds) {
        this.partIds = partIds;
    }

    public String[] getPartIds() {
        return this.partIds;
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
        this.hasRootTranslation = configType.startsWith("T1");
        if (!this.hasRootTranslation) {
            this.hasTranslation = configType.indexOf(84) >= 0;
        }
        this.hasRotation = configType.indexOf(82) >= 0;
        this.hasScale = configType.indexOf(83) >= 0;
        this.hasVelocity = configType.indexOf(86) >= 0;
        this.hasAngularVelocity = configType.indexOf(87) >= 0;
    }

    public void setRotationEncoding(String rotationEncoding) {
        this.rotationEncoding = rotationEncoding;
    }

    public int getConfigSize() {
        return this.config == null ? 0 : this.config.length;
    }

    public int size() {
        return this.config == null ? 0 : this.config.length;
    }

    public void setTargets(VObject[] targets) {
        this.targetParts = new VObject[this.partIds.length];
        for (int i = 0; i < this.partIds.length; ++i) {
            for (int j = 0; j < targets.length; ++j) {
                if ((targets[j].getId() == null || !targets[j].getId().equals(this.partIds[i])) && (targets[j].getSid() == null || !targets[j].getSid().equals(this.partIds[i]))) continue;
                this.targetParts[i] = targets[j];
                logger.debug("targetParts[{}]={}", (Object)i, (Object)this.partIds[i]);
            }
        }
    }

    public void setToTarget() {
        int index = 0;
        if (this.hasRootTranslation && this.targetParts.length > 0) {
            this.targetParts[0].setTranslation(this.config);
            index += 3;
        }
        for (int i = 0; i < this.targetParts.length; ++i) {
            if (this.hasTranslation) {
                this.targetParts[i].setTranslation(this.config, index);
                index += 3;
            }
            if (this.hasRotation) {
                this.targetParts[i].setRotation(this.config, index);
                index += 4;
            }
            if (this.hasScale) {
                this.targetParts[i].setScale(this.config, index);
                index += 3;
            }
            if (this.hasVelocity) {
                this.targetParts[i].setVelocity(this.config, index);
                index += 3;
            }
            if (!this.hasAngularVelocity) continue;
            this.targetParts[i].setAngularVelocity(this.config, index);
            index += 3;
        }
    }

    public void setFromTarget() {
        int index = 0;
        if (this.hasRootTranslation && this.targetParts.length > 0) {
            this.targetParts[0].getTranslation(this.config);
            index += 3;
        }
        for (int i = 0; i < this.targetParts.length; ++i) {
            if (this.hasTranslation) {
                this.targetParts[i].getTranslation(this.config, index);
                index += 3;
            }
            if (this.hasRotation) {
                this.targetParts[i].getRotation(this.config, index);
                index += 4;
            }
            if (this.hasScale) {
                this.targetParts[i].getScale(this.config, index);
                index += 3;
            }
            if (this.hasVelocity) {
                this.targetParts[i].getVelocity(this.config, index);
                index += 3;
            }
            if (!this.hasAngularVelocity) continue;
            this.targetParts[i].getAngularVelocity(this.config, index);
            index += 3;
        }
    }

    public String getRotationEncoding() {
        return this.rotationEncoding;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String parts = this.getRequiredAttribute("parts", attrMap, tokenizer);
        this.partIds = SkeletonPose.decodeStringArray((String)parts);
        String encoding = this.getRequiredAttribute("encoding", attrMap, tokenizer);
        this.setConfigType(encoding);
        this.rotationEncoding = this.getOptionalAttribute("rotationEncoding", attrMap, "Quat");
        super.decodeAttributes(attrMap, tokenizer);
    }

    public void decodeContent(XMLTokenizer xmlTokenizer) throws IOException {
        this.calculateConfigSize();
        if (xmlTokenizer.atCharData()) {
            String data = xmlTokenizer.takeCharData();
            StringTokenizer tokenizer = new StringTokenizer(data);
            while (tokenizer.hasMoreTokens()) {
                this.config = new float[this.configSize];
                for (int i = 0; i < this.configSize; ++i) {
                    this.config[i] = (float)Double.parseDouble(tokenizer.nextToken());
                }
            }
            if (this.rotationEncoding != null && this.rotationEncoding.equals("axisangles")) {
                this.convertFromAxisAngles();
            }
        }
    }

    private void convertFromAxisAngles() {
        int startIndex;
        for (int ri = startIndex = this.hasRootTranslation ? 3 : 0; ri < this.configSize; ri += this.stride) {
            Quat4f.setFromAxisAngle4f((float[])this.config, (int)ri, (float[])this.config, (int)ri);
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

