/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.VJoint;
import hmi.math.Vec3f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;

public class Skeleton
extends XMLStructureAdapter {
    private final VJoint rootJoint;
    private static final String XMLTAG = "Skeleton";

    public Skeleton(VJoint root) {
        this.rootJoint = root;
    }

    public StringBuilder appendJoint(VJoint v, StringBuilder buf) {
        return buf;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        VJointXML vjXML = new VJointXML(this.rootJoint);
        return vjXML.appendXML(buf, fmt);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    private static class VJointXML
    extends XMLStructureAdapter {
        private final VJoint joint;
        private static final String XMLTAG = "Joint";

        public VJointXML(VJoint v) {
            this.joint = v;
        }

        public StringBuilder appendAttributeString(StringBuilder buf) {
            VJointXML.appendAttribute((StringBuilder)buf, (String)"sid", (String)this.joint.getSid());
            float[] trans = Vec3f.getVec3f();
            this.joint.getTranslation(trans);
            VJointXML.appendAttribute((StringBuilder)buf, (String)"translation", (String)(trans[0] + " " + trans[1] + " " + trans[2]));
            return buf;
        }

        public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
            for (VJoint vj : this.joint.getChildren()) {
                VJointXML vjXML = new VJointXML(vj);
                vjXML.appendXML(buf, fmt);
            }
            return buf;
        }

        public static String xmlTag() {
            return XMLTAG;
        }

        public String getXMLTag() {
            return XMLTAG;
        }
    }
}

