/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.VObject;
import hmi.math.Mat3f;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.util.Console;
import hmi.util.Diff;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class VJoint
implements VObject {
    private static Logger logger = Logger.getLogger("hmi.animation.VJoint");
    private String id;
    private String sid;
    private String name;
    private VJoint parent;
    private ArrayList<VJoint> children;
    public static final int DEFAULTCAPACITY = 4;
    private float[] translation = Vec3f.getVec3f();
    private float[] rotation = Quat4f.getIdentity();
    private Mat3f.ScalingType scalingType = Mat3f.ScalingType.IDENTITY;
    private float[] scaleVec = null;
    private float[] scaleMatrix = null;
    private final float[] localMatrix = Mat4f.getIdentity();
    private final float[] globalMatrix = Mat4f.getIdentity();
    private boolean validLocalMatrix = false;
    private boolean hasSharedBuffers = false;
    float[] qw = new float[4];
    float[] qp = new float[4];
    float[] q2 = new float[4];
    public static final int TAB = 6;

    public VJoint() {
        this(null, 4);
    }

    public VJoint(String id) {
        this(id, 4);
    }

    public VJoint(String id, int capacity) {
        this.children = new ArrayList(capacity);
        this.setId(id);
    }

    public String showLocalDiff(String msg, Object vjointObj) {
        float[] matrix2;
        VJoint vj = (VJoint)vjointObj;
        if (vj == null) {
            return "VJoint " + this.id + ", diff: null VJoint";
        }
        String diff = Diff.showDiff((String)"VJoint, id", (String)this.id, (String)vj.id);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)"VJoint, sid", (String)this.sid, (String)vj.sid);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)"VJoint, name", (String)this.name, (String)vj.name);
        if (diff != "") {
            return diff;
        }
        float[] matrix1 = this.getLocalMatrix();
        if (!Mat4f.epsilonEquals((float[])matrix1, (float[])(matrix2 = vj.getLocalMatrix()), (float)0.001f) && (diff = Diff.showDiff((String)("GNode " + this.id + ", diff Transform matrices"), (float[])matrix1, (float[])matrix2)) != "") {
            return diff;
        }
        return "";
    }

    @Override
    public void setId(String id) {
        this.id = id == null ? null : id.intern();
    }

    @Override
    public void setSid(String sid) {
        this.sid = sid == null ? null : sid.intern();
    }

    @Override
    public void setName(String name) {
        this.name = name == null ? null : name.intern();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSid() {
        return this.sid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getIds() {
        StringBuilder buf = new StringBuilder();
        if (this.id != null) {
            buf.append("id=");
            buf.append(this.id);
        }
        if (this.sid != null) {
            buf.append("   sid=");
            buf.append(this.sid);
        }
        if (this.name != null) {
            buf.append("   name=");
            buf.append(this.name);
        }
        if (this.id == null && this.sid == null && this.name == null) {
            buf.append("---");
        }
        return buf.toString();
    }

    public boolean equivId(VJoint vj) {
        return this.id != null && this.id == vj.id || this.sid != null && this.sid == vj.sid;
    }

    public boolean equivName(VJoint vj) {
        return this.id != null && this.id == vj.id || this.sid != null && this.sid == vj.sid || this.name != null && this.name == vj.name;
    }

    public Mat3f.ScalingType getScalingType() {
        return this.scalingType;
    }

    public VJoint getParent() {
        return this.parent;
    }

    public void setParent(VJoint parent) {
        this.parent = parent;
    }

    public void addChild(VJoint newChild) {
        if (newChild == null) {
            logger.warning("VJoint id=\"" + this.id + "\" : addPart(null)");
            return;
        }
        this.children.add(newChild);
        newChild.setParent(this);
    }

    public void removeChild(VJoint vo) {
        this.children.remove(vo);
    }

    public List<VJoint> getChildren() {
        return this.children;
    }

    public VJoint getPart(String partIdent) {
        if (partIdent == null) {
            return null;
        }
        return this.searchPart(partIdent.intern());
    }

    private VJoint searchPart(String searchId) {
        if (searchId == this.id || searchId == this.sid || searchId == this.name) {
            return this;
        }
        for (VJoint vchild : this.children) {
            VJoint childPart = vchild.searchPart(searchId);
            if (childPart == null) continue;
            return childPart;
        }
        return null;
    }

    public VJoint getPartById(String partId) {
        if (partId == null) {
            return null;
        }
        return this.searchPartById(partId.intern());
    }

    private VJoint searchPartById(String searchId) {
        if (searchId == this.id) {
            return this;
        }
        for (VJoint vchild : this.children) {
            VJoint childPart = vchild.searchPartById(searchId);
            if (childPart == null) continue;
            return childPart;
        }
        return null;
    }

    public VJoint getPartBySid(String partSid) {
        if (partSid == null) {
            return null;
        }
        return this.searchPartBySid(partSid.intern());
    }

    private VJoint searchPartBySid(String searchSid) {
        if (this.sid == searchSid) {
            return this;
        }
        for (VJoint vchild : this.children) {
            if (vchild.sid != searchSid) continue;
            return vchild;
        }
        for (VJoint vchild : this.children) {
            VJoint childPart = vchild.searchPartBySid(searchSid);
            if (childPart == null) continue;
            return childPart;
        }
        return null;
    }

    public List<VJoint> getParts() {
        return this.getParts(null, null);
    }

    public List<VJoint> getParts(VObject.Predicate select) {
        return this.getParts(select, null);
    }

    public List<VJoint> getParts(VObject.Predicate select, VObject.Predicate prune) {
        return this.getParts(select, prune, new ArrayList<VJoint>());
    }

    public List<VJoint> getParts(VObject.Predicate select, VObject.Predicate prune, ArrayList<VJoint> list) {
        if (select == null || select.valid(this)) {
            list.add(this);
        }
        if (prune == null || !prune.valid(this)) {
            for (VJoint vchild : this.children) {
                vchild.getParts(select, prune, list);
            }
        }
        return list;
    }

    private List<VJoint> getVObjectPath(VJoint root, List<VJoint> path) {
        path.add(0, this);
        if (root != this && this.parent != null) {
            return this.parent.getVObjectPath(root, path);
        }
        return path;
    }

    public VJoint copy(String newId) {
        VJoint copy = new VJoint();
        copy.id = newId;
        copy.sid = this.sid;
        copy.name = this.name;
        copy.setTranslation(this.translation);
        copy.setRotation(this.rotation);
        return copy;
    }

    public VJoint copyTree(String idPrefix) {
        VJoint copy = this.copy(idPrefix + this.id);
        for (VJoint vchild : this.children) {
            VJoint childClone = vchild.copyTree(idPrefix);
            copy.addChild(childClone);
        }
        return copy;
    }

    public VJoint masterCopy(String idPrefix) {
        VJoint master = this.copy(idPrefix);
        this.setTranslationBuffer(master.getTranslationBuffer());
        this.setRotationBuffer(master.getRotationBuffer());
        return master;
    }

    public VJoint masterCopyTree(String idPrefix) {
        VJoint master = this.masterCopy(idPrefix + this.id);
        for (VJoint vchild : this.children) {
            VJoint childClone = vchild.masterCopyTree(idPrefix);
            master.addChild(childClone);
        }
        return master;
    }

    public VJoint slaveCopy(String newId) {
        VJoint slave = new VJoint();
        slave.id = newId;
        slave.sid = this.sid;
        slave.name = this.name;
        slave.setTranslationBuffer(this.getTranslationBuffer());
        slave.setRotationBuffer(this.getRotationBuffer());
        return slave;
    }

    public VJoint slaveCopyTree(String idPrefix) {
        VJoint slave = this.slaveCopy(idPrefix + this.id);
        for (VJoint vchild : this.children) {
            VJoint childClone = vchild.slaveCopyTree(idPrefix);
            slave.addChild(childClone);
        }
        return slave;
    }

    public List<VJoint> getVObjectPath(VJoint root) {
        return this.getVObjectPath(root, new ArrayList<VJoint>(8));
    }

    @Override
    public void getTranslation(float[] t) {
        System.arraycopy(this.translation, 0, t, 0, 3);
    }

    @Override
    public void getTranslation(float[] vc, int vcIndex) {
        System.arraycopy(this.translation, 0, vc, vcIndex, 3);
    }

    public float[] getTranslationBuffer() {
        this.hasSharedBuffers = true;
        return this.translation;
    }

    public void setTranslationBuffer(float[] ta) {
        this.translation = ta;
        this.hasSharedBuffers = true;
        this.validLocalMatrix = false;
    }

    @Override
    public void setTranslation(float[] ta) {
        System.arraycopy(ta, 0, this.translation, 0, 3);
        this.validLocalMatrix = false;
    }

    @Override
    public void setTranslation(float[] ta, int taIndex) {
        System.arraycopy(ta, taIndex, this.translation, 0, 3);
        this.validLocalMatrix = false;
    }

    @Override
    public void setTranslation(float tx, float ty, float tz) {
        this.translation[0] = tx;
        this.translation[1] = ty;
        this.translation[2] = tz;
        this.validLocalMatrix = false;
    }

    public void clearTranslation() {
        this.translation[0] = 0.0f;
        this.translation[1] = 0.0f;
        this.translation[2] = 0.0f;
        this.validLocalMatrix = false;
    }

    public void translate(float[] tvec) {
        Vec3f.add((float[])this.translation, (float[])tvec);
        this.validLocalMatrix = false;
    }

    public boolean hasTranslation() {
        return this.translation[0] != 0.0f || this.translation[1] != 0.0f || this.translation[2] != 0.0f;
    }

    @Override
    public void setRotation(float[] ra) {
        System.arraycopy(ra, 0, this.rotation, 0, 4);
        this.validLocalMatrix = false;
    }

    public void setPathRotation(float[] q, VJoint rootJoint) {
        if (rootJoint == this) {
            this.setRotation(q);
        } else {
            Quat4f.set((float[])this.qw, (float[])q);
            VJoint parent = this.getParent();
            parent.getPathRotation(rootJoint, this.qp);
            Quat4f.inverse((float[])this.qp);
            Quat4f.mul((float[])this.q2, (float[])this.qp, (float[])this.qw);
            this.setRotation(this.q2);
        }
    }

    @Override
    public void setRotation(float[] ra, int raIndex) {
        System.arraycopy(ra, raIndex, this.rotation, 0, 4);
        this.validLocalMatrix = false;
    }

    @Override
    public void getRotation(float[] r) {
        System.arraycopy(this.rotation, 0, r, 0, 4);
    }

    @Override
    public void getRotation(float[] r, int index) {
        System.arraycopy(this.rotation, 0, r, index, 4);
    }

    public void getRotation(double[] r, int index) {
        for (int i = 0; i < 4; ++i) {
            r[index + i] = this.rotation[i];
        }
    }

    public void getTranslation(double[] t) {
        for (int i = 0; i < 3; ++i) {
            t[i] = this.translation[i];
        }
    }

    public void getTranslation(double[] t, int index) {
        for (int i = 0; i < 3; ++i) {
            t[index + i] = this.translation[i];
        }
    }

    public float[] getRotationBuffer() {
        this.hasSharedBuffers = true;
        return this.rotation;
    }

    public void setRotationBuffer(float[] rot) {
        this.rotation = rot;
        this.hasSharedBuffers = true;
        this.validLocalMatrix = false;
    }

    @Override
    public void setRotation(float qs, float qx, float qy, float qz) {
        Quat4f.set((float[])this.rotation, (float)qs, (float)qx, (float)qy, (float)qz);
        this.validLocalMatrix = false;
    }

    public void clearRotation() {
        Quat4f.set((float[])this.rotation, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.validLocalMatrix = false;
    }

    @Override
    public void setAxisAngle(float ax, float ay, float az, float angle) {
        Quat4f.setFromAxisAngle4f((float[])this.rotation, (float)ax, (float)ay, (float)az, (float)angle);
        this.validLocalMatrix = false;
    }

    public void setRollPitchYawDegrees(float roll, float pitch, float yaw) {
        Quat4f.setFromRollPitchYawDegrees((float[])this.rotation, (float)roll, (float)pitch, (float)yaw);
        this.validLocalMatrix = false;
    }

    public void rotate(float[] rq) {
        Quat4f.mul((float[])this.rotation, (float[])rq, (float[])this.rotation);
        this.validLocalMatrix = false;
    }

    public void rotateAxisAngle(float ax, float ay, float az, float angle) {
        this.rotate(Quat4f.getQuat4fFromAxisAngle((float)ax, (float)ay, (float)az, (float)angle));
    }

    public boolean hasRotation() {
        return this.rotation[0] != 1.0f;
    }

    public void rotateJoint(float[] rq) {
        Quat4f.mul((float[])this.rotation, (float[])rq, (float[])this.rotation);
        Quat4f.transformVec3f((float[])rq, (float[])this.translation);
        this.validLocalMatrix = false;
    }

    public void rotateScaleJoint(float[] rq, float scale) {
        Console.println((String)("VJoint.rotateScaleJoint " + Quat4f.explainQuat4f((float[])rq, (int)4, (int)2) + "\ntranslation: " + Vec3f.toString((float[])this.translation, (int)4, (int)3)));
        Quat4f.transformVec3f((float[])rq, (float[])this.translation);
        Vec3f.scale((float)scale, (float[])this.translation);
        Console.println((String)("translation: " + Vec3f.toString((float[])this.translation, (int)4, (int)3)));
        this.validLocalMatrix = false;
    }

    public void affineTransform(float[] ma) {
        this.getLocalMatrix();
        Mat4f.transformAffineMatrix((float[])ma, (float[])this.localMatrix);
        this.decomposeLocalMatrix();
    }

    public boolean isRigid() {
        return this.scalingType == Mat3f.ScalingType.IDENTITY;
    }

    public void setScale(float s) {
        this.setScale(s, s, s);
    }

    public void setScale(float sx, float sy, float sz) {
        if (sx == 1.0f && sy == 1.0f && sz == 1.0f) {
            this.scalingType = Mat3f.ScalingType.IDENTITY;
            this.scaleVec = null;
            this.scaleMatrix = null;
        } else {
            if (this.scaleVec == null) {
                this.scaleVec = new float[]{sx, sy, sz};
            } else {
                this.scaleVec[0] = sx;
                this.scaleVec[1] = sy;
                this.scaleVec[2] = sz;
            }
            this.scalingType = Mat3f.ScalingType.ALIGNED;
            this.scaleMatrix = null;
        }
        this.validLocalMatrix = false;
    }

    public void scale(float sx, float sy, float sz) {
        if (sx == 1.0f && sy == 1.0f && sz == 1.0f) {
            return;
        }
        switch (this.scalingType) {
            case IDENTITY: {
                this.setScale(sx, sy, sz);
                break;
            }
            case ALIGNED: {
                this.scaleVec[0] = this.scaleVec[0] * sx;
                this.scaleVec[1] = this.scaleVec[1] * sy;
                this.scaleVec[2] = this.scaleVec[2] * sz;
                break;
            }
            case SKEW: {
                this.scaleMatrix[0] = this.scaleMatrix[0] * sx;
                this.scaleMatrix[4] = this.scaleMatrix[4] * sy;
                this.scaleMatrix[8] = this.scaleMatrix[8] * sz;
                break;
            }
            default: {
                Console.println((String)("VJoint.getLocalMatrix: unknown scaling type: " + this.scalingType));
            }
        }
    }

    public void scale(float s) {
        this.scale(s, s, s);
    }

    public void clearScale() {
        this.scaleVec = null;
        this.scaleMatrix = null;
        this.scalingType = Mat3f.ScalingType.IDENTITY;
        this.validLocalMatrix = false;
    }

    @Override
    public void setScale(float[] sa) {
        this.setScale(sa[0], sa[1], sa[2]);
    }

    @Override
    public void setScale(float[] sa, int saIndex) {
        this.setScale(sa[saIndex], sa[saIndex + 1], sa[saIndex + 2]);
    }

    @Override
    public void getScale(float[] r) {
        this.getScale(r, 0);
    }

    @Override
    public void getScale(float[] r, int index) {
        if (this.scaleVec != null) {
            System.arraycopy(this.scaleVec, 0, r, index, 3);
        } else {
            r[index + 2] = 1.0f;
            r[index + 1] = 1.0f;
            r[index] = 1.0f;
        }
    }

    public void setSkewMatrix(float[] matrix) {
        this.scaleMatrix = matrix;
        this.scaleVec = null;
        this.scalingType = Mat3f.ScalingType.SKEW;
        this.validLocalMatrix = false;
    }

    public float[] getSkewMatrix() {
        return this.scaleMatrix;
    }

    public boolean hasScaling() {
        return this.scalingType != Mat3f.ScalingType.IDENTITY;
    }

    public final float[] getLocalMatrix() {
        if (!this.validLocalMatrix || this.hasSharedBuffers) {
            switch (this.scalingType) {
                case IDENTITY: {
                    Mat4f.setFromTR((float[])this.localMatrix, (float[])this.translation, (float[])this.rotation);
                    break;
                }
                case ALIGNED: {
                    Mat4f.setFromTRSVec3f((float[])this.localMatrix, (float[])this.translation, (float[])this.rotation, (float[])this.scaleVec);
                    break;
                }
                case SKEW: {
                    Mat4f.setFromTRSMat3f((float[])this.localMatrix, (float[])this.translation, (float[])this.rotation, (float[])this.scaleMatrix);
                    break;
                }
                default: {
                    Console.println((String)("VJoint.getLocalMatrix: unknown scaling type: " + this.scalingType));
                }
            }
            this.validLocalMatrix = true;
        }
        return this.localMatrix;
    }

    public void setLocalTransform(float[] matrix) {
        Mat4f.set((float[])this.localMatrix, (float[])matrix);
        this.decomposeLocalMatrix();
    }

    private void decomposeLocalMatrix() {
        this.validLocalMatrix = true;
        if (!Mat4f.isAffine((float[])this.localMatrix)) {
            this.scalingType = Mat3f.ScalingType.SKEW;
            return;
        }
        if (this.scaleMatrix == null) {
            this.scaleMatrix = new float[9];
        }
        Mat4f.decomposeToTRSMat3f((float[])this.localMatrix, (float[])this.translation, (float[])this.rotation, (float[])this.scaleMatrix);
        float epsilon = 1.0E-4f;
        Mat3f.smooth((float[])this.scaleMatrix, (float)epsilon);
        this.scalingType = Mat3f.getScalingType((float[])this.scaleMatrix);
        if (this.scalingType != Mat3f.ScalingType.SKEW) {
            if (this.scaleVec == null) {
                this.scaleVec = new float[3];
            }
            Mat3f.getDiagonal((float[])this.scaleMatrix, (float[])this.scaleVec);
            this.scaleMatrix = null;
        }
    }

    public void clearLocalAffineTransform() {
        this.clearScale();
        this.clearRotation();
        this.clearTranslation();
        this.getLocalMatrix();
    }

    public void clearLocalLinearTransform() {
        this.clearScale();
        this.clearRotation();
        this.getLocalMatrix();
    }

    public final void setLocalMatrix(float[] matrix4f) {
        Mat4f.set((float[])this.localMatrix, (float[])matrix4f);
    }

    public final float[] getGlobalMatrix() {
        return this.globalMatrix;
    }

    public String localMatrixToString() {
        return Mat4f.toString((float[])this.getLocalMatrix());
    }

    public String globalMatrixToString() {
        return Mat4f.toString((float[])this.globalMatrix);
    }

    public void calculateMatrices() {
        this.calculateMatrices(Mat4f.ID);
    }

    public void calculateMatrices(float[] parentGlobalMatrix) {
        Mat4f.mul((float[])this.globalMatrix, (float[])parentGlobalMatrix, (float[])this.getLocalMatrix());
        for (VJoint vchild : this.children) {
            vchild.calculateMatrices(this.globalMatrix);
        }
    }

    public void getPathTransformMatrix(VJoint rootObject, float[] m) {
        if (rootObject == this) {
            Mat4f.set((float[])m, (float[])this.getLocalMatrix());
        } else if (this.parent != null) {
            this.parent.getPathTransformMatrix(rootObject, m);
            Mat4f.mul((float[])m, (float[])m, (float[])this.getLocalMatrix());
        } else {
            if (rootObject != null) {
                throw new IllegalArgumentException("Root joint not found " + rootObject.sid);
            }
            Mat4f.set((float[])m, (float[])this.getLocalMatrix());
        }
    }

    public void pathTransform(VJoint rootJoint, float[] pt) {
        if (rootJoint == this) {
            return;
        }
        Mat4f.transformPoint((float[])this.getLocalMatrix(), (float[])pt);
        if (this.parent == null) {
            if (rootJoint != null) {
                throw new IllegalArgumentException("Root joint not found " + rootJoint.sid);
            }
            return;
        }
        this.parent.pathTransform(rootJoint, pt);
    }

    private boolean getPath(VJoint target, List<VJoint> path) {
        for (VJoint vj : this.children) {
            if (vj == target) {
                path.add(vj);
                return true;
            }
            if (!vj.getPath(target, path)) continue;
            path.add(vj);
            return true;
        }
        return false;
    }

    public List<VJoint> getPath(VJoint target) {
        ArrayList<VJoint> path = new ArrayList<VJoint>();
        this.getPath(target, path);
        path.add(this);
        return path;
    }

    public void getPathRotation(VJoint rootJoint, float[] quat) {
        if (rootJoint == this) {
            Quat4f.setIdentity((float[])quat);
        } else if (this.parent != null) {
            this.parent.getPathRotation(rootJoint, quat);
            if ((double)this.rotation[0] < 1.0) {
                Quat4f.mul((float[])quat, (float[])this.rotation);
            }
        } else {
            if (rootJoint != null) {
                throw new IllegalArgumentException("Root joint not found " + rootJoint.sid);
            }
            Quat4f.setIdentity((float[])quat);
        }
    }

    public void getPathTranslation(VJoint rootJoint, float[] vec) {
        Vec3f.set((float[])vec, (float)0.0f, (float)0.0f, (float)0.0f);
        this.pathTransform(rootJoint, vec);
    }

    public float[] getPosition() {
        return this.getPosition(new float[3]);
    }

    public float[] getPosition(float[] positionVec) {
        if (positionVec == null) {
            positionVec = new float[3];
        }
        Vec3f.set((float[])positionVec, (float)0.0f, (float)0.0f, (float)0.0f);
        this.pathTransform(null, positionVec);
        return positionVec;
    }

    public float[] getRelativePositionFrom(VJoint ancestorJoint) {
        float[] relPos = this.getPosition();
        float[] ancestorPos = ancestorJoint.getPosition(null);
        Vec3f.sub((float[])relPos, (float[])ancestorPos);
        return relPos;
    }

    @Override
    public void getVelocity(float[] v) {
        throw new UnsupportedOperationException("getVelocity not suported for VJoints");
    }

    @Override
    public void getVelocity(float[] vc, int vcIndex) {
        throw new UnsupportedOperationException("getVelocity not suported for VJoints");
    }

    @Override
    public void setVelocity(float[] v) {
        throw new UnsupportedOperationException("getVelocity not suported for VJoints");
    }

    @Override
    public void setVelocity(float[] vc, int vcIndex) {
        throw new UnsupportedOperationException("setVelocity not suported for VJoints");
    }

    @Override
    public void setVelocity(float vx, float vy, float vz) {
        throw new UnsupportedOperationException("setVelocity not suported for VJoints");
    }

    @Override
    public void getAngularVelocity(float[] v) {
        throw new UnsupportedOperationException("getAngularVelocity not suported for VJoints");
    }

    @Override
    public void getAngularVelocity(float[] vc, int vcIndex) {
        throw new UnsupportedOperationException("getAngularVelocity not suported for VJoints");
    }

    @Override
    public void setAngularVelocity(float[] v) {
        throw new UnsupportedOperationException("setAngularVelocity not suported for VJoints");
    }

    @Override
    public void setAngularVelocity(float[] vc, int vcIndex) {
        throw new UnsupportedOperationException("setAngularVelocity not suported for VJoints");
    }

    @Override
    public void setAngularVelocity(float wx, float wy, float wz) {
        throw new UnsupportedOperationException("setAngularVelocity not suported for VJoints");
    }

    private String idts(String s) {
        return s == null ? "null" : s;
    }

    private void newLine(StringBuilder buf, int tab) {
        buf.append('\n');
        for (int i = 0; i < tab; ++i) {
            buf.append(' ');
        }
    }

    public StringBuilder appendTo(StringBuilder buf, int tab) {
        int i;
        buf.append("VJoint[  id=\"");
        buf.append(this.idts(this.id));
        buf.append("\"  sid=\"");
        buf.append(this.idts(this.sid));
        buf.append("\"  name=\"");
        buf.append(this.idts(this.name));
        buf.append("\"]\n");
        for (i = 0; i < tab; ++i) {
            buf.append(' ');
        }
        buf.append("translation=");
        buf.append(Vec3f.toString((float[])this.translation));
        buf.append('\n');
        for (i = 0; i < tab; ++i) {
            buf.append(' ');
        }
        buf.append("rotation=");
        buf.append(Quat4f.toString((float[])this.rotation));
        if (this.scaleVec != null) {
            buf.append('\n');
            for (i = 0; i < tab; ++i) {
                buf.append(' ');
            }
            buf.append("scalevec=");
            buf.append(Vec3f.toString((float[])this.scaleVec));
        }
        return buf;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(), 0).toString();
    }

    public String showSkeleton() {
        return this.showSkeleton(0, 10000);
    }

    public String showSkeleton(int detail, int level) {
        StringBuilder buf = this.appendSkeleton(new StringBuilder(), 0, detail, level);
        return buf.toString();
    }

    public StringBuilder appendSkeleton(StringBuilder buf, int tab, int detail, int level) {
        this.newLine(buf, tab);
        buf.append("VJoint[");
        buf.append("  id=\"" + this.idts(this.id));
        buf.append("\"  sid=\"" + this.idts(this.sid));
        buf.append("\"  name=\"" + this.idts(this.name));
        buf.append('\"');
        if (detail >= 1) {
            this.newLine(buf, tab);
            buf.append("translation=" + Vec3f.toString((float[])this.translation));
            this.newLine(buf, tab);
            buf.append("rotation=" + Quat4f.toString((float[])this.rotation));
            this.newLine(buf, tab);
            buf.append(this.scaleVec == null ? "no scaling" : "scaleVec=" + Vec3f.toString((float[])this.scaleVec));
        }
        if (detail >= 2) {
            this.newLine(buf, tab);
            buf.append("localMatrix=" + Mat4f.toString((float[])this.localMatrix, (int)tab));
            this.newLine(buf, tab);
            buf.append("globalMatrix=" + Mat4f.toString((float[])this.globalMatrix, (int)tab));
            this.newLine(buf, tab);
            buf.append(" validLocalMatrix=");
            buf.append(this.validLocalMatrix);
            this.newLine(buf, tab);
            buf.append(" hasSharedBuffers=");
            buf.append(this.hasSharedBuffers);
        }
        if (level > 0) {
            for (VJoint child : this.children) {
                child.appendSkeleton(buf, tab + 6, detail, level - 1);
            }
        }
        this.newLine(buf, tab);
        buf.append("]");
        return buf;
    }

    public boolean getHasSharedBuffers() {
        return this.hasSharedBuffers;
    }
}

