/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.ConfigList;
import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.util.ClockListener;
import hmi.util.Resources;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkeletonInterpolator
extends XMLStructureAdapter
implements ClockListener {
    private static Logger logger = LoggerFactory.getLogger((String)SkeletonInterpolator.class.getName());
    private static final String[] empty_PartIds = new String[0];
    private String[] partIds = empty_PartIds;
    private ConfigList configs;
    private String configType;
    private int configSize;
    private int stride;
    private boolean hasRootTranslation;
    private boolean hasTranslation;
    private boolean hasRotation;
    private boolean hasScale;
    private boolean hasVelocity;
    private boolean hasAngularVelocity;
    private String rotationEncoding = "Quat";
    private VObject[] targetParts;
    private VJoint target;
    private int lowerIndex;
    private int upperIndex;
    private double lowerTime;
    private double upperTime;
    private double interval;
    private float[] lowerConfig;
    private float[] upperConfig;
    private float[] buf = new float[4];
    private static final String XMLTAG = "SkeletonInterpolator";

    public SkeletonInterpolator(XMLTokenizer tokenizer) throws IOException {
        this.readXML(tokenizer);
    }

    public SkeletonInterpolator(String[] partIds, ConfigList configs, String configType) {
        this.setPartIds(partIds);
        this.setConfigList(configs);
        this.setConfigType(configType);
        this.calculateConfigSize();
    }

    public SkeletonInterpolator(SkeletonInterpolator p, VObject[] targetParts) {
        this.setPartIds((String[])p.partIds.clone());
        this.setConfigList(p.configs.copy());
        this.setConfigType(p.configType);
        this.stride = p.stride;
        this.hasRootTranslation = p.hasRootTranslation;
        this.hasTranslation = p.hasTranslation;
        this.hasRotation = p.hasRotation;
        this.hasScale = p.hasScale;
        this.hasVelocity = p.hasVelocity;
        this.hasAngularVelocity = p.hasAngularVelocity;
        this.rotationEncoding = p.rotationEncoding;
        this.target = p.target;
        this.targetParts = targetParts;
    }

    public SkeletonInterpolator(SkeletonInterpolator p) {
        this.setPartIds((String[])p.partIds.clone());
        this.setConfigList(p.configs.copy());
        this.setConfigType(p.configType);
        this.stride = p.stride;
        this.hasRootTranslation = p.hasRootTranslation;
        this.hasTranslation = p.hasTranslation;
        this.hasRotation = p.hasRotation;
        this.hasScale = p.hasScale;
        this.hasVelocity = p.hasVelocity;
        this.hasAngularVelocity = p.hasAngularVelocity;
        this.rotationEncoding = p.rotationEncoding;
        this.targetParts = p.targetParts;
        this.target = p.target;
    }

    public SkeletonInterpolator() {
        this.configs = new ConfigList(0);
    }

    public void setConfigList(ConfigList configs) {
        this.configs = configs;
        if (configs != null && configs.size() != 0) {
            this.upperIndex = 0;
            this.lowerIndex = 0;
            this.lowerTime = this.upperTime = configs.getTime(0);
            this.interval = 0.0;
        }
    }

    public ConfigList getConfigList() {
        return this.configs;
    }

    public void setPartIds(String[] partIds) {
        this.partIds = partIds;
    }

    public String[] getPartIds() {
        return this.partIds;
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
        this.hasRootTranslation = configType.startsWith("T1");
        if (!this.hasRootTranslation) {
            this.hasTranslation = configType.indexOf(84) >= 0;
        }
        this.hasRotation = configType.indexOf(82) >= 0;
        this.hasScale = configType.indexOf(83) >= 0;
        this.hasVelocity = configType.indexOf(86) >= 0;
        this.hasAngularVelocity = configType.indexOf(87) >= 0;
    }

    private void calculateConfigSize() {
        this.stride = 0;
        if (this.hasTranslation) {
            this.stride += 3;
        }
        if (this.hasRotation) {
            this.stride += 4;
        }
        if (this.hasScale) {
            this.stride += 3;
        }
        if (this.hasVelocity) {
            this.stride += 3;
        }
        if (this.hasAngularVelocity) {
            this.stride += 3;
        }
        this.configSize = this.stride * this.partIds.length;
        if (this.hasRootTranslation) {
            this.configSize += 3;
        }
    }

    public void setRotationEncoding(String rotationEncoding) {
        this.rotationEncoding = rotationEncoding;
    }

    public int getConfigSize() {
        return this.configs == null ? 0 : this.configs.getConfigSize();
    }

    public int size() {
        return this.configs == null ? 0 : this.configs.size();
    }

    public double getTime(int i) {
        return this.configs == null ? 0.0 : this.configs.getTime(i);
    }

    public float[] getConfig(int i) {
        return this.configs == null ? null : this.configs.getConfig(i);
    }

    public double getStartTime() {
        return this.configs == null ? 0.0 : this.configs.getStartTime();
    }

    public double getEndTime() {
        return this.configs == null ? 0.0 : this.configs.getEndTime();
    }

    public void setTarget(VJoint target) {
        this.target = target;
        if (target == null) {
            this.targetParts = null;
        } else {
            if (this.targetParts == null) {
                this.targetParts = new VJoint[this.partIds.length];
            }
            for (int i = 0; i < this.partIds.length; ++i) {
                this.targetParts[i] = target.getPart(this.partIds[i]);
            }
        }
    }

    private int getWidth(int partIndex) {
        int width = 0;
        if (this.hasRootTranslation && partIndex == 0) {
            width += 3;
        } else if (this.hasTranslation) {
            width += 3;
        }
        if (this.hasRotation) {
            width += 4;
        }
        if (this.hasScale) {
            width += 3;
        }
        if (this.hasVelocity) {
            width += 3;
        }
        if (this.hasAngularVelocity) {
            width += 3;
        }
        return width;
    }

    private void filterTargetParts(Set<String> joints) {
        ArrayList<VObject> newParts = new ArrayList<VObject>();
        int i = 0;
        for (VObject vj : this.targetParts) {
            if (joints.contains(this.partIds[i])) {
                newParts.add(vj);
            }
            ++i;
        }
        this.targetParts = newParts.toArray(new VObject[0]);
    }

    public void filterJoints(Set<String> joints) {
        int index = 0;
        ArrayList<String> newPartIds = new ArrayList<String>();
        int configSize = 0;
        boolean removeRoot = false;
        for (int i = 0; i < this.partIds.length; ++i) {
            if (joints.contains(this.partIds[i])) {
                newPartIds.add(this.partIds[i]);
                configSize += this.getWidth(i);
            } else if (i == 0) {
                removeRoot = true;
            }
            index += this.getWidth(i);
        }
        ConfigList newConfig = new ConfigList(configSize);
        for (int j = 0; j < this.configs.size(); ++j) {
            float[] src = this.configs.getConfig(j);
            float[] dst = new float[configSize];
            int newConfigIndex = 0;
            index = 0;
            for (int i = 0; i < this.partIds.length; ++i) {
                if (joints.contains(this.partIds[i])) {
                    System.arraycopy(src, index, dst, newConfigIndex, this.getWidth(i));
                    newConfigIndex += this.getWidth(i);
                }
                index += this.getWidth(i);
            }
            newConfig.addConfig(this.configs.getTime(j), dst);
        }
        if (this.targetParts != null) {
            this.filterTargetParts(joints);
        }
        this.setPartIds(newPartIds.toArray(new String[0]));
        this.setConfigList(newConfig);
        if (removeRoot) {
            this.hasRootTranslation = false;
            if (this.configType.startsWith("T1")) {
                this.configType = this.configType.substring(2);
            }
        }
    }

    public void interpolateMillis(long time) {
        this.interpolateTargetParts((double)time / 1000.0);
    }

    public float[] getInterpolatedConfig(double t, float[] conf) {
        if (this.configs.size() == 0) {
            return null;
        }
        if (conf == null) {
            conf = new float[this.configs.getConfig(0).length];
        }
        float alpha = this.getInterpolationConfigs(t);
        int index = 0;
        if (this.hasRootTranslation && this.partIds.length > 0) {
            Vec3f.interpolate((float[])conf, (int)0, (float[])this.lowerConfig, (int)0, (float[])this.upperConfig, (int)0, (float)alpha);
            index += 3;
        }
        for (int i = 0; i < this.partIds.length; ++i) {
            if (this.hasTranslation) {
                Vec3f.interpolate((float[])conf, (int)index, (float[])this.lowerConfig, (int)index, (float[])this.upperConfig, (int)index, (float)alpha);
                index += 3;
            }
            if (this.hasRotation) {
                Quat4f.interpolate((float[])conf, (int)index, (float[])this.lowerConfig, (int)index, (float[])this.upperConfig, (int)index, (float)alpha);
                index += 4;
            }
            if (this.hasScale) {
                Vec3f.interpolate((float[])conf, (int)index, (float[])this.lowerConfig, (int)index, (float[])this.upperConfig, (int)index, (float)alpha);
                index += 3;
            }
            if (this.hasVelocity) {
                Vec3f.interpolate((float[])conf, (int)index, (float[])this.lowerConfig, (int)index, (float[])this.upperConfig, (int)index, (float)alpha);
                index += 3;
            }
            if (!this.hasAngularVelocity) continue;
            Vec3f.interpolate((float[])conf, (int)index, (float[])this.lowerConfig, (int)index, (float[])this.upperConfig, (int)index, (float)alpha);
            index += 3;
        }
        return conf;
    }

    public void initTime(double t) {
    }

    public void time(double t) {
        this.interpolateTargetParts(t);
    }

    public void setTargetParts(int c) {
        float[] config = this.getConfig(c);
        int index = 0;
        if (this.hasRootTranslation) {
            this.targetParts[0].setTranslation(config, index);
            index += 3;
        }
        for (int i = 0; i < this.targetParts.length; ++i) {
            if (this.hasTranslation) {
                this.targetParts[i].setTranslation(config, index);
                index += 3;
            }
            if (this.hasRotation) {
                this.targetParts[i].setRotation(config, index);
                index += 4;
            }
            if (!this.hasScale) continue;
            this.targetParts[i].setScale(config, index);
            index += 3;
        }
    }

    public void interpolateTargetParts(double time) {
        if (this.targetParts == null) {
            return;
        }
        if (this.configs.size() == 0) {
            return;
        }
        float alpha = this.getInterpolationConfigs(time);
        int index = 0;
        if (this.hasRootTranslation) {
            Vec3f.interpolate((float[])this.buf, (int)0, (float[])this.lowerConfig, (int)0, (float[])this.upperConfig, (int)0, (float)alpha);
            this.targetParts[0].setTranslation(this.buf);
            index += 3;
        }
        for (int i = 0; i < this.targetParts.length; ++i) {
            if (this.targetParts[i] == null) continue;
            if (this.hasTranslation) {
                Vec3f.interpolate((float[])this.buf, (int)0, (float[])this.lowerConfig, (int)index, (float[])this.upperConfig, (int)index, (float)alpha);
                this.targetParts[i].setTranslation(this.buf);
                index += 3;
            }
            if (this.hasRotation) {
                Quat4f.interpolate((float[])this.buf, (int)0, (float[])this.lowerConfig, (int)index, (float[])this.upperConfig, (int)index, (float)alpha);
                this.targetParts[i].setRotation(this.buf);
                index += 4;
            }
            if (!this.hasScale) continue;
            Vec3f.interpolate((float[])this.buf, (int)0, (float[])this.lowerConfig, (int)index, (float[])this.upperConfig, (int)index, (float)alpha);
            this.targetParts[i].setScale(this.buf);
            index += 3;
        }
    }

    private float getInterpolationConfigs(double t) {
        if (this.lowerTime <= t && t < this.upperTime) {
            return (float)((t - this.lowerTime) / this.interval);
        }
        if (t < this.lowerTime) {
            if (t < this.configs.getStartTime()) {
                this.upperIndex = 0;
                this.lowerIndex = 0;
            } else {
                this.upperIndex = this.lowerIndex;
                this.lowerIndex = 0;
            }
        } else if (t >= this.configs.getEndTime()) {
            this.lowerIndex = this.upperIndex = this.configs.size() - 1;
        } else {
            this.lowerIndex = this.upperIndex;
            this.upperIndex = t < this.configs.getTime(this.lowerIndex + 1) ? this.lowerIndex + 1 : this.configs.size() - 1;
        }
        while (this.upperIndex - this.lowerIndex > 1) {
            int probe = (this.upperIndex + this.lowerIndex) / 2;
            if (t < this.configs.getTime(probe)) {
                this.upperIndex = probe;
                continue;
            }
            this.lowerIndex = probe;
        }
        if (this.upperIndex != this.lowerIndex + 1 && this.upperIndex != this.lowerIndex) {
            logger.debug("***********************************");
        }
        if (this.upperIndex != this.lowerIndex + 1 && this.upperIndex != this.lowerIndex) {
            logger.debug("lowerindex: {}", (Object)this.lowerIndex);
            logger.debug("upperindex: {}", (Object)this.upperIndex);
            logger.debug("-------------------");
        }
        this.lowerTime = this.configs.getTime(this.lowerIndex);
        this.upperTime = this.configs.getTime(this.upperIndex);
        this.lowerConfig = this.configs.getConfig(this.lowerIndex);
        this.upperConfig = this.configs.getConfig(this.upperIndex);
        this.interval = this.upperTime - this.lowerTime;
        float alpha = this.interval <= 0.0 ? 0.0f : (float)((t - this.lowerTime) / this.interval);
        return alpha;
    }

    public void sampleTargetParts(double time) {
        if (this.targetParts == null) {
            return;
        }
        if (this.configs.size() == 0) {
            return;
        }
        float[] newConfig = new float[this.configSize];
        int index = 0;
        if (this.hasRootTranslation) {
            this.targetParts[0].getTranslation(newConfig, index);
            index += 3;
        }
        for (int i = 0; i < this.targetParts.length; ++i) {
            if (this.hasTranslation) {
                this.targetParts[i].getTranslation(newConfig, index);
                index += 3;
            }
            if (this.hasRotation) {
                this.targetParts[i].getRotation(newConfig, index);
                index += 4;
            }
            if (!this.hasScale) continue;
            this.targetParts[i].getScale(newConfig, index);
            index += 3;
        }
        this.configs.addConfig(time, newConfig);
    }

    private void mirrorParts(int i) {
        if (this.targetParts != null && this.targetParts.length > 0 && !this.targetParts[i].getSid().equals(this.partIds[i])) {
            for (int j = 0; j < this.targetParts.length; ++j) {
                if (!this.targetParts[j].getSid().equals(this.partIds[i])) continue;
                VObject temp = this.targetParts[i];
                this.targetParts[i] = this.targetParts[j];
                this.targetParts[j] = temp;
                return;
            }
            this.targetParts[i] = this.target.getPart(this.partIds[i]);
        }
    }

    public void mirror() {
        int index = 0;
        if (this.hasRootTranslation) {
            index += 3;
        }
        for (int i = 0; i < this.partIds.length; ++i) {
            if (this.partIds[i].startsWith("l_")) {
                this.partIds[i] = this.partIds[i].replace("l_", "r_");
                this.mirrorParts(i);
            } else if (this.partIds[i].startsWith("r_")) {
                this.partIds[i] = this.partIds[i].replace("r_", "l_");
                this.mirrorParts(i);
            }
            if (this.hasTranslation) {
                index += 3;
            }
            if (this.hasRotation) {
                logger.debug("mirroring {}, index {}", (Object)this.partIds[i], (Object)index);
                this.configs.mirror(index);
                index += 4;
            }
            if (this.hasScale) {
                index += 3;
            }
            if (this.hasVelocity) {
                index += 3;
            }
            if (!this.hasAngularVelocity) continue;
            index += 3;
        }
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        SkeletonInterpolator.appendAttribute((StringBuilder)buf, (String)"encoding", (String)this.configType);
        if (this.rotationEncoding != null) {
            SkeletonInterpolator.appendAttribute((StringBuilder)buf, (String)"rotationEncoding", (String)this.rotationEncoding);
        }
        if (this.partIds != null && this.partIds.length > 0) {
            buf.append(" parts=\"");
            buf.append(this.partIds[0]);
            for (int i = 1; i < this.partIds.length; ++i) {
                buf.append(' ');
                buf.append(this.partIds[i]);
            }
            buf.append("\"");
        }
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String parts = this.getRequiredAttribute("parts", attrMap, tokenizer);
        this.partIds = SkeletonInterpolator.decodeStringArray((String)parts);
        String encoding = this.getRequiredAttribute("encoding", attrMap, tokenizer);
        this.setConfigType(encoding);
        this.rotationEncoding = this.getOptionalAttribute("rotationEncoding", attrMap, "Quat");
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.configs.appendContent(buf, fmt);
        return buf;
    }

    public void decodeContent(XMLTokenizer xmlTokenizer) throws IOException {
        this.calculateConfigSize();
        this.configs = new ConfigList(this.configSize);
        this.configs.decodeContent(xmlTokenizer);
        if (this.rotationEncoding != null && this.rotationEncoding.equals("axisangles")) {
            this.convertFromAxisAngles();
        }
    }

    public void decodeContent(String data) {
        this.calculateConfigSize();
        this.configs = new ConfigList(this.configSize);
        this.configs.decodeContent(data);
        if (this.rotationEncoding != null && this.rotationEncoding.equals("axisangles")) {
            this.convertFromAxisAngles();
        }
    }

    private void convertFromAxisAngles() {
        for (int i = 0; i < this.configs.size(); ++i) {
            int startIndex;
            float[] conf = this.configs.getConfig(i);
            for (int ri = startIndex = this.hasRootTranslation ? 3 : 0; ri < this.configSize; ri += this.stride) {
                Quat4f.setFromAxisAngle4f((float[])conf, (int)ri, (float[])conf, (int)ri);
            }
        }
    }

    public static SkeletonInterpolator read(Resources resources, String fileName) throws IOException {
        BufferedReader reader = resources.getReader(fileName);
        XMLTokenizer tk = new XMLTokenizer((Reader)reader);
        SkeletonInterpolator ip = new SkeletonInterpolator(tk);
        ((Reader)reader).close();
        return ip;
    }

    public static SkeletonInterpolator read(String resourceDir, String fileName) throws IOException {
        Resources resources = new Resources(resourceDir);
        BufferedReader reader = resources.getReader(fileName);
        XMLTokenizer tk = new XMLTokenizer((Reader)reader);
        return new SkeletonInterpolator(tk);
    }

    public static SkeletonInterpolator read(String fileName) throws IOException {
        Resources resources = new Resources("");
        BufferedReader reader = resources.getReader(fileName);
        XMLTokenizer tk = new XMLTokenizer((Reader)reader);
        return new SkeletonInterpolator(tk);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public VObject[] getTargetParts() {
        return this.targetParts;
    }
}

