/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.math.Quat4f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.StringTokenizer;

public class ConfigList
extends XMLStructureAdapter
implements Cloneable {
    private double[] time = new double[this.arraySize];
    private float[][] configList = new float[this.arraySize][];
    private int listSize = 0;
    private int arraySize = 8;
    private static final int DEFAULTARRAYSIZE = 8;
    private int configSize;
    private static final String XMLTAG = "ConfigList";

    public ConfigList(int configSize) {
        this.configSize = configSize;
    }

    public ConfigList copy() {
        ConfigList c = new ConfigList(this.configSize);
        c.time = (double[])this.time.clone();
        c.listSize = this.listSize;
        c.arraySize = this.arraySize;
        c.configList = new float[this.arraySize][];
        for (int i = 0; i < this.listSize; ++i) {
            c.configList[i] = new float[this.configSize];
            for (int j = 0; j < this.configSize; ++j) {
                c.configList[i][j] = this.configList[i][j];
            }
        }
        return c;
    }

    public ConfigList(XMLTokenizer tokenizer) throws IOException {
        this(0);
        this.readXML(tokenizer);
    }

    public int getConfigSize() {
        return this.configSize;
    }

    public int size() {
        return this.listSize;
    }

    public double getTime(int i) {
        return this.time[i];
    }

    public void mirror(int index) {
        for (int i = 0; i < this.listSize; ++i) {
            float[] config = this.configList[i];
            float[] q = Quat4f.getQuat4f();
            Quat4f.set((float[])q, (int)0, (float[])config, (int)index);
            Quat4f.set((float[])config, (int)index, (float)q[0], (float)q[1], (float)(-q[2]), (float)(-q[3]));
        }
    }

    public float[] getConfig(int i) {
        return this.configList[i];
    }

    public double getStartTime() {
        return this.listSize == 0 ? 0.0 : this.time[0];
    }

    public double getEndTime() {
        return this.listSize == 0 ? 0.0 : this.time[this.listSize - 1];
    }

    public void addConfig(double t, float[] conf) {
        this.ensureArraySize(this.listSize + 1);
        int pos = this.findInsertIndex(t);
        for (int p = this.listSize; p > pos; --p) {
            this.configList[p] = this.configList[p - 1];
            this.time[p] = this.time[p - 1];
        }
        this.time[pos] = t;
        this.configList[pos] = conf;
        ++this.listSize;
    }

    private void ensureArraySize(int requestedSize) {
        if (requestedSize <= this.arraySize) {
            return;
        }
        while (this.arraySize < requestedSize) {
            this.arraySize *= 2;
        }
        float[][] newConfigList = new float[this.arraySize][];
        double[] newTime = new double[this.arraySize];
        System.arraycopy(this.configList, 0, newConfigList, 0, this.listSize);
        System.arraycopy(this.time, 0, newTime, 0, this.listSize);
        this.configList = newConfigList;
        this.time = newTime;
    }

    private int findInsertIndex(double t) {
        int low = 0;
        int high = this.listSize - 1;
        if (this.listSize == 0 || t < this.time[low]) {
            return 0;
        }
        if (t >= this.time[high]) {
            return this.listSize;
        }
        while (high - low > 1) {
            int probe = high + low >>> 1;
            if (t < this.time[probe]) {
                high = probe;
                continue;
            }
            low = probe;
        }
        return high;
    }

    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        ConfigList.appendAttribute((StringBuilder)buf, (String)"configSize", (int)this.configSize);
        return buf;
    }

    public boolean decodeAttribute(String attrName, String valCode, XMLTokenizer tokenizer) {
        if (attrName.equals("configSize")) {
            this.configSize = ConfigList.decodeInt((String)valCode);
            return true;
        }
        return super.decodeAttribute(attrName, valCode, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        for (int i = 0; i < this.listSize; ++i) {
            ConfigList.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
            buf.append(Double.toString(this.time[i]));
            float[] c = this.configList[i];
            for (int j = 0; j < c.length; ++j) {
                buf.append(' ');
                buf.append(Float.toString(c[j]));
            }
        }
        return buf;
    }

    public void decodeContent(XMLTokenizer xmlTokenizer) throws IOException {
        String data = xmlTokenizer.takeCharData();
        this.decodeContent(data);
    }

    public void decodeContent(String data) {
        StringTokenizer tokenizer = new StringTokenizer(data);
        while (tokenizer.hasMoreTokens()) {
            double t = Double.parseDouble(tokenizer.nextToken());
            float[] conf = new float[this.configSize];
            for (int i = 0; i < this.configSize; ++i) {
                conf[i] = (float)Double.parseDouble(tokenizer.nextToken());
            }
            this.addConfig(t, conf);
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

