// Generated by delombok at Fri Sep 04 12:49:37 CEST 2015
package hmi.animation.motiongraph.graphutils;

import hmi.animation.motiongraph.Edge;
import hmi.animation.motiongraph.MotionGraph;
import hmi.animation.motiongraph.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Based on the graph algorithms from<br>
 * CS 161 - Design and Analysis of Algorithms, Stanford, by Mark Zhandry<br>
 * @see <a href="http://crypto.stanford.edu/~zhandry/2012-Summer-CS161/">CS161</a>
 * @author herwinvw
 */
public final class GraphUtils {

    private GraphUtils() {
    }

    public static final class NopVisitor implements Visitor {


        @Override
        public void visit(Node n) {
        }
    }

    public static final class NopUpdater implements Updater {


        @Override
        public void update() {
        }
    }

    public static final class NopHitVisited implements HitVisited {


        @Override
        public void hitVisited(Node u, Node n, Edge e) {
        }
    }

    public static MotionGraph reverse(MotionGraph mg) {
        Map<Integer, Node> nodesReverse = new HashMap<>();
        List<Edge> edgesReverse = new ArrayList<>();
        for (Node n : mg.getNodes()) {
            Node nrev = new Node();
            nrev.setId(n.getId());
            nodesReverse.put(n.getId(), nrev);
        }
        for (Edge e : mg.getEdges()) {
            Node startNode = nodesReverse.get(e.getEndNode().getId());
            Node endNode = nodesReverse.get(e.getStartNode().getId());
            Edge eReverse = new Edge(startNode, endNode, e.getMotion());
            eReverse.setId(e.getId());
            startNode.addOutgoingEdge(eReverse);
            endNode.addIncomingEdge(eReverse);
            edgesReverse.add(eReverse);
        }
        return new MotionGraph.Builder(edgesReverse, nodesReverse.values()).getInstance();
    }

    /**
     * For each node, finds its connected components number
     */
    public static Map<Node, Integer> getConnected(MotionGraph g) {

        class Marker implements Visitor, Updater {
            private int cc = 0;
            private Map<Node, Integer> connected = new HashMap<>();

            @Override
            public void update() {
                cc++;
            }

            @Override
            public void visit(Node n) {
                connected.put(n, cc);
            }

            @java.lang.SuppressWarnings("all")
            public Map<Node, Integer> getConnected() {
                return this.connected;
            }
        }
        Marker marker = new Marker();
        DepthFirstSearch.search(g, marker, new NopVisitor(), marker, new NopHitVisited());
        return marker.getConnected();
    }

    public static Map<Node, Integer> getPostNumbers(MotionGraph g) {

        class PostCounter implements Visitor {
            Map<Node, Integer> post = new HashMap<>();
            int count = 0;

            @Override
            public void visit(Node n) {
                post.put(n, count);
                count++;
            }

            @java.lang.SuppressWarnings("all")
            public Map<Node, Integer> getPost() {
                return this.post;
            }
        }
        PostCounter pc = new PostCounter();
        DepthFirstSearch.search(g, new NopVisitor(), pc, new NopUpdater(), new NopHitVisited());
        return pc.getPost();
    }

    static final class SCCDAGEdge {
        final int start;
        final int end;

        @java.beans.ConstructorProperties({"start", "end"})
        @java.lang.SuppressWarnings("all")
        public SCCDAGEdge(final int start, final int end) {
            this.start = start;
            this.end = end;
        }

        @java.lang.SuppressWarnings("all")
        public int getStart() {
            return this.start;
        }

        @java.lang.SuppressWarnings("all")
        public int getEnd() {
            return this.end;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof GraphUtils.SCCDAGEdge)) return false;
            final SCCDAGEdge other = (SCCDAGEdge)o;
            if (this.getStart() != other.getStart()) return false;
            if (this.getEnd() != other.getEnd()) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            result = result * PRIME + this.getStart();
            result = result * PRIME + this.getEnd();
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "GraphUtils.SCCDAGEdge(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }
    }

    public static final class SCCDAGNode {
        final int id;

        public SCCDAGNode(int id) {
            this.id = id;
        }

        public void addIncomingEdge(SCCDAGEdge e) {
            incomingEdges.add(e);
        }

        public void addOutgoingEdge(SCCDAGEdge e) {
            outgoingEdges.add(e);
        }
        private Set<SCCDAGEdge> incomingEdges = new HashSet<>();
        private Set<SCCDAGEdge> outgoingEdges = new HashSet<>();

        @java.lang.SuppressWarnings("all")
        public int getId() {
            return this.id;
        }

        @java.lang.SuppressWarnings("all")
        public Set<SCCDAGEdge> getIncomingEdges() {
            return this.incomingEdges;
        }

        @java.lang.SuppressWarnings("all")
        public Set<SCCDAGEdge> getOutgoingEdges() {
            return this.outgoingEdges;
        }
    }

    public static final class SCCDAG {
        final List<SCCDAGNode> nodes;
        final Map<Node, Integer> innerNodeMap; // maps graph node to SCC node
        final Set<SCCDAGEdge> edges;

        public Set<Node> getNodes(int sccId) {
            Set<Node> nodes = new HashSet<>();
            for (Entry<Node, Integer> entry : innerNodeMap.entrySet()) {
                if (entry.getValue() == sccId) {
                    nodes.add(entry.getKey());
                }
            }
            return nodes;
        }

        @java.beans.ConstructorProperties({"nodes", "innerNodeMap", "edges"})
        @java.lang.SuppressWarnings("all")
        public SCCDAG(final List<SCCDAGNode> nodes, final Map<Node, Integer> innerNodeMap, final Set<SCCDAGEdge> edges) {
            this.nodes = nodes;
            this.innerNodeMap = innerNodeMap;
            this.edges = edges;
        }

        @java.lang.SuppressWarnings("all")
        public List<SCCDAGNode> getNodes() {
            return this.nodes;
        }

        @java.lang.SuppressWarnings("all")
        public Map<Node, Integer> getInnerNodeMap() {
            return this.innerNodeMap;
        }

        @java.lang.SuppressWarnings("all")
        public Set<SCCDAGEdge> getEdges() {
            return this.edges;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof GraphUtils.SCCDAG)) return false;
            final SCCDAG other = (SCCDAG)o;
            final java.lang.Object this$nodes = this.getNodes();
            final java.lang.Object other$nodes = other.getNodes();
            if (this$nodes == null ? other$nodes != null : !this$nodes.equals(other$nodes)) return false;
            final java.lang.Object this$innerNodeMap = this.getInnerNodeMap();
            final java.lang.Object other$innerNodeMap = other.getInnerNodeMap();
            if (this$innerNodeMap == null ? other$innerNodeMap != null : !this$innerNodeMap.equals(other$innerNodeMap)) return false;
            final java.lang.Object this$edges = this.getEdges();
            final java.lang.Object other$edges = other.getEdges();
            if (this$edges == null ? other$edges != null : !this$edges.equals(other$edges)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $nodes = this.getNodes();
            result = result * PRIME + ($nodes == null ? 0 : $nodes.hashCode());
            final java.lang.Object $innerNodeMap = this.getInnerNodeMap();
            result = result * PRIME + ($innerNodeMap == null ? 0 : $innerNodeMap.hashCode());
            final java.lang.Object $edges = this.getEdges();
            result = result * PRIME + ($edges == null ? 0 : $edges.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "GraphUtils.SCCDAG(nodes=" + this.getNodes() + ", innerNodeMap=" + this.getInnerNodeMap() + ", edges=" + this.getEdges() + ")";
        }
    }

    public static SCCDAG getStronglyConnectedComponents(MotionGraph g) {
        Map<Node, Integer> postMap = getPostNumbers(reverse(g));
        List<Entry<Node, Integer>> postEntries = new ArrayList<>(postMap.entrySet());
        Collections.sort(postEntries, new Comparator<Entry<Node, Integer>>(){

            @Override
            public int compare(Entry<Node, Integer> arg0, Entry<Node, Integer> arg1) {
                if (arg0.getValue() < arg1.getValue()) return 1;
                if (arg0.getValue() > arg1.getValue()) return -1;
                return 0;
            }
        });
        List<Node> nodes = new ArrayList<>();
        for (Entry<Node, Integer> entry : postEntries) {
            nodes.add(g.getNode(entry.getKey().getId()));
        }

        class Marker implements Visitor, Updater, HitVisited {
            private int cc = 0;
            private Map<Node, Integer> connected = new HashMap<>();
            private Set<SCCDAGEdge> edges = new HashSet<>();

            @Override
            public void update() {
                cc++;
            }

            @Override
            public void visit(Node n) {
                connected.put(n, cc);
            }

            @Override
            public void hitVisited(Node u, Node n, Edge e) {
                if (connected.containsKey(n)) {
                    int scc = connected.get(n);
                    if (scc != cc) {
                        edges.add(new SCCDAGEdge(cc, scc));
                    }
                }
            }

            @java.lang.SuppressWarnings("all")
            public int getCc() {
                return this.cc;
            }

            @java.lang.SuppressWarnings("all")
            public Map<Node, Integer> getConnected() {
                return this.connected;
            }

            @java.lang.SuppressWarnings("all")
            public Set<SCCDAGEdge> getEdges() {
                return this.edges;
            }
        }
        Marker marker = new Marker();
        DepthFirstSearch.search(nodes, new NopVisitor(), marker, marker, marker);
        List<SCCDAGNode> dagnodes = new ArrayList<>();
        for (int i = 1; i <= marker.getCc(); i++) {
            SCCDAGNode n = new SCCDAGNode(i);
            for (SCCDAGEdge e : marker.getEdges()) {
                if (e.getStart() == i) {
                    n.addOutgoingEdge(e);
                }
                if (e.getEnd() == i) {
                    n.addIncomingEdge(e);
                }
            }
            dagnodes.add(n);
        }
        return new SCCDAG(dagnodes, marker.getConnected(), marker.getEdges());
    }

    /**
     * Prune all Sink SCCs from the motiongraph that have less than pruneSize nodes
     */
    public static final void pruneSinkSCCs(MotionGraph mg, int pruneSize) {
        boolean pruned = false;
        while (!pruned) {
            pruned = true;
            SCCDAG dag = getStronglyConnectedComponents(mg);
            for (SCCDAGNode n : dag.nodes) {
                Set<Node> innerNodes = dag.getNodes(n.getId());
                if (n.getOutgoingEdges().isEmpty() && innerNodes.size() < pruneSize) {
                    mg.removeNodes(innerNodes);
                    pruned = false;
                }
            }
        }
    }
}