/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import hmi.animation.VJoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public final class VJointUtils {
    private VJointUtils() {
    }

    public static Collection<VJoint> intersection(Collection<VJoint> vj1, Collection<VJoint> vj2) {
        ArrayList<VJoint> vjOut = new ArrayList<VJoint>(vj1);
        return Collections2.filter(vjOut, (Predicate)new VJointInCollectionPredicate(vj2));
    }

    public static Set<String> transformToSidSet(Collection<VJoint> joints) {
        Collection j = Collections2.transform(joints, (Function)new Function<VJoint, String>(){

            public String apply(VJoint joint) {
                return joint.getSid();
            }
        });
        return ImmutableSet.copyOf((Collection)j);
    }

    public static class VJointInCollectionPredicate
    implements Predicate<VJoint> {
        private final Collection<VJoint> jointCol;

        public VJointInCollectionPredicate(Collection<VJoint> collection) {
            this.jointCol = collection;
        }

        public boolean apply(VJoint vj) {
            for (VJoint joint : this.jointCol) {
                if (!joint.equivId(vj)) continue;
                return true;
            }
            return false;
        }
    }
}

