/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.Skeleton;
import hmi.animation.SkeletonPose;
import hmi.animation.VJoint;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationDistributor2 {
    private static final Logger log = LoggerFactory.getLogger(AnimationDistributor2.class);
    private DatagramSocket socket;
    private int serverPort = 4445;
    private int senderPort = 4433;
    private InetAddress serverAddress;
    private ByteArrayOutputStream byteOut = null;
    private DataOutputStream dataOut = null;
    private DatagramPacket packet = null;
    byte[] buf;
    SkeletonPose pose;
    private VJoint root;
    private ArrayList<Skeleton> skeletons = new ArrayList(8);
    private ArrayList<SkeletonPose> skeletonPoses = new ArrayList(16);
    private List<String> partList;
    private static final ArrayList<String> EMPTY_LIST = new ArrayList(0);
    private Skeleton testSkeleton;
    private SkeletonPose testPose;

    public AnimationDistributor2(int serverPort, int senderPort) throws Exception {
        this.serverPort = serverPort;
        this.senderPort = senderPort;
        log.info("AnimationDistributor running...");
        this.init();
    }

    public AnimationDistributor2() throws Exception {
        this(4445, 4433);
    }

    private void init() throws Exception {
        String characterId = "Relion";
        this.addSkeleton(AnimationDistributor2.relionSkeleton(characterId));
        List<String> partIds = Arrays.asList("Pelvis", "L5", "L3", "T12", "T8", "Neck", "Head", "LeftShoulder", "LeftUpperArm", "LeftForeArm", "LeftHand", "RightShoulder", "RightUpperArm", "RightForeArm", "RightHand", "LeftUpperLeg", "LeftLowerLeg", "LeftFoot", "LeftToe", "RightUpperLeg", "RightLowerLeg", "RightFoot", "RightToe");
        this.addSkeletonPose("pose", characterId, partIds, "R");
        this.initSender();
    }

    protected boolean addSkeleton(Skeleton newSkel) {
        for (Skeleton skel : this.skeletons) {
            if (!skel.getId().equals(newSkel.getId())) continue;
            return false;
        }
        this.skeletons.add(newSkel);
        return true;
    }

    public Skeleton getSkeleton(String id) {
        for (Skeleton skel : this.skeletons) {
            if (!skel.getId().equals(id)) continue;
            return skel;
        }
        return null;
    }

    public Skeleton getSkeleton() {
        return this.skeletons.isEmpty() ? null : this.skeletons.get(0);
    }

    public List<String> getAvailableSkeletonIds() {
        ArrayList<String> result = new ArrayList<String>(this.skeletons.size());
        for (Skeleton skel : this.skeletons) {
            result.add(skel.getId());
        }
        return result;
    }

    public SkeletonPose addSkeletonPose(String poseId, String skeletonId, List<String> partIdents, String configType) {
        Skeleton skel = this.getSkeleton(skeletonId);
        if (skel == null) {
            log.error("addSkeletonPose: Skeleton for " + skeletonId + " not available");
            return null;
        }
        SkeletonPose skPose = new SkeletonPose(poseId, skel, partIdents, configType);
        this.addPose(skPose);
        return skPose;
    }

    private void addPose(SkeletonPose pose) {
        this.skeletonPoses.add(pose);
    }

    public SkeletonPose getSkeletonPose(String poseId) {
        for (SkeletonPose pose : this.skeletonPoses) {
            if (!pose.getId().equals(poseId)) continue;
            return pose;
        }
        return null;
    }

    public synchronized void snapshot() {
        for (SkeletonPose pose : this.skeletonPoses) {
            pose.fromSkeleton();
            this.send(pose);
        }
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setServerAddress(String host) throws UnknownHostException {
        this.serverAddress = InetAddress.getByName(host);
    }

    private void initSender() throws UnknownHostException, SocketException {
        if (this.serverAddress == null) {
            this.serverAddress = InetAddress.getLocalHost();
        }
        this.socket = new DatagramSocket(this.senderPort);
        this.byteOut = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.byteOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(SkeletonPose pose) {
        if (this.dataOut == null) {
            log.error("Cannot send, no relion connection");
            return;
        }
        try {
            this.byteOut.reset();
            pose.writeBinary(this.dataOut);
            this.dataOut.flush();
            this.buf = this.byteOut.toByteArray();
            DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length, this.serverAddress, this.serverPort);
            log.debug(pose.toString());
            this.socket.send(packet);
        }
        catch (IOException e) {
            log.error("AnimationDistributor: " + e);
        }
    }

    public static Skeleton relionSkeleton(String characterId) {
        VJoint pelvis = new VJoint(characterId + "-Pelvis", "Pelvis");
        VJoint l5 = new VJoint(characterId + "-L5", "L5");
        VJoint l3 = new VJoint(characterId + "-L3", "L3");
        VJoint t12 = new VJoint(characterId + "-T12", "T12");
        VJoint t8 = new VJoint(characterId + "-T8", "T8");
        VJoint neck = new VJoint(characterId + "-Neck", "Neck");
        VJoint head = new VJoint(characterId + "-Head", "Head");
        VJoint rightShoulder = new VJoint(characterId + "-RightShoulder", "RightShoulder");
        VJoint rightUpperArm = new VJoint(characterId + "-RightUpperArm", "RightUpperArm");
        VJoint rightForeArm = new VJoint(characterId + "-RightForeArm", "RightForeArm");
        VJoint rightHand = new VJoint(characterId + "-RightHand", "RightHand");
        VJoint leftShoulder = new VJoint(characterId + "-LeftShoulder", "LeftShoulder");
        VJoint leftUpperArm = new VJoint(characterId + "-LeftUpperArm", "LeftUpperArm");
        VJoint leftForeArm = new VJoint(characterId + "-LeftForeArm", "LeftForeArm");
        VJoint leftHand = new VJoint(characterId + "-LeftHand", "LeftHand");
        VJoint rightUpperLeg = new VJoint(characterId + "-RightUpperLeg", "RightUpperLeg");
        VJoint rightLowerLeg = new VJoint(characterId + "-RightLowerLeg", "RightLowerLeg");
        VJoint rightFoot = new VJoint(characterId + "-RightFoot", "RightFoot");
        VJoint rightToe = new VJoint(characterId + "-RightToe", "RightToe");
        VJoint leftUpperLeg = new VJoint(characterId + "-LeftUpperLeg", "LeftUpperLeg");
        VJoint leftLowerLeg = new VJoint(characterId + "-LeftLowerLeg", "LeftLowerLeg");
        VJoint leftFoot = new VJoint(characterId + "-LeftFoot", "LeftFoot");
        VJoint leftToe = new VJoint(characterId + "-LeftToe", "LeftToe");
        pelvis.addChild(l5);
        l5.addChild(l3);
        l3.addChild(t12);
        t12.addChild(t8);
        t8.addChild(neck);
        neck.addChild(head);
        t8.addChild(rightShoulder);
        rightShoulder.addChild(rightUpperArm);
        rightUpperArm.addChild(rightForeArm);
        rightForeArm.addChild(rightHand);
        t8.addChild(leftShoulder);
        leftShoulder.addChild(leftUpperArm);
        leftUpperArm.addChild(leftForeArm);
        leftForeArm.addChild(leftHand);
        pelvis.addChild(rightUpperLeg);
        rightUpperLeg.addChild(rightLowerLeg);
        rightLowerLeg.addChild(rightFoot);
        rightFoot.addChild(rightToe);
        pelvis.addChild(leftUpperLeg);
        leftUpperLeg.addChild(leftLowerLeg);
        leftLowerLeg.addChild(leftFoot);
        leftFoot.addChild(leftToe);
        Skeleton skel = new Skeleton(characterId);
        skel.setRoot(pelvis);
        return skel;
    }
}

