/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.AnimationDistributor;
import hmi.animation.Skeleton;
import hmi.animation.SkeletonPose;
import hmi.util.Console;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Arrays;
import java.util.List;

public class UDPServer {
    private DatagramSocket socket;
    private int serverport = 4445;
    private int senderport = 4433;
    SkeletonPose skelPose;
    Skeleton skel = AnimationDistributor.relionSkeleton("relion");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDPServer() {
        List<String> partIds = Arrays.asList("LeftShoulder", "LeftUpperArm", "LeftForeArm", "RightShoulder", "RightUpperArm", "RightForeArm");
        this.skelPose = new SkeletonPose("pose", partIds, "R");
        try {
            try {
                Console.println((String)("UDPServer starting on " + this.serverport + "..."));
                this.socket = new DatagramSocket(this.serverport);
                while (true) {
                    byte[] buf = new byte[256];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    this.socket.receive(packet);
                    Console.println((String)"UDPServer received a packet");
                    ByteArrayInputStream binIn = new ByteArrayInputStream(buf);
                    DataInputStream dataIn = new DataInputStream(binIn);
                    Console.println((String)"Received:");
                    for (int i = 0; i < 20; ++i) {
                        float f = dataIn.readFloat();
                        Console.print((String)(" " + f));
                    }
                    Console.println();
                }
            }
            catch (IOException e) {
                Console.println((String)("startServer: " + e));
                this.socket.close();
            }
        }
        catch (Throwable throwable) {
            this.socket.close();
            throw throwable;
        }
    }

    public static void main(String[] arg) {
        Console.setLocation((int)1400, (int)20);
        Console.println((String)"UDPServer starting...");
        new UDPServer();
    }
}

