/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.Skeleton;
import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.math.Quat4f;
import hmi.util.Console;
import hmi.util.Ident;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkeletonPose
extends XMLStructureAdapter
implements Ident {
    private static final String[] empty_PartIds = new String[0];
    private String[] partIds = empty_PartIds;
    private float[] config;
    private String configType;
    private int configSize;
    private int stride;
    private boolean hasRootTranslation;
    private boolean hasTranslation;
    private boolean hasRotation;
    private boolean hasScale;
    private boolean hasVelocity;
    private boolean hasAngularVelocity;
    private String rotationEncoding = null;
    private VObject[] targetParts;
    private String id;
    private static Logger logger = LoggerFactory.getLogger((String)SkeletonPose.class.getName());
    private static final String XMLTAG = "SkeletonPose";

    public SkeletonPose(XMLTokenizer tokenizer) throws IOException {
        this.readXML(tokenizer);
    }

    public SkeletonPose(String[] partIds, float[] config, String configType) {
        this.setPartIds(partIds);
        this.setConfig(config);
        this.setConfigType(configType);
        this.calculateConfigSize();
    }

    public SkeletonPose(String id, String[] partIds, String configType) {
        this.setId(id);
        this.setPartIds(partIds);
        this.setConfigType(configType);
        this.calculateConfigSize();
        this.config = new float[this.configSize];
        this.setConfig(this.config);
    }

    public SkeletonPose(String id, List<String> partIds, String configType) {
        this.setId(id);
        this.setPartIds(partIds.toArray(new String[partIds.size()]));
        this.setConfigType(configType);
        this.calculateConfigSize();
        this.config = new float[this.configSize];
        this.setConfig(this.config);
    }

    private SkeletonPose(String id, VObject[] targets, String configType) {
        this.setId(id);
        this.targetParts = targets;
        this.setPartIds(targets);
        this.setConfigType(configType);
        this.calculateConfigSize();
        this.config = new float[this.configSize];
        this.setConfig(this.config);
    }

    public SkeletonPose(Skeleton skeleton, String configType) {
        this(null, skeleton, configType);
    }

    public SkeletonPose(String id, Skeleton skeleton, String configType) {
        this(id, skeleton, new ArrayList<String>(), configType);
    }

    public SkeletonPose(String id, Skeleton skeleton, String[] partIdents, String configType) {
        this(id, skeleton, Arrays.asList(partIdents), configType);
    }

    public SkeletonPose(String id, Skeleton skeleton, List<String> partIdents, String configType) {
        this.setId(id);
        List<VJoint> joints = skeleton.getRoot().getParts(partIdents);
        for (VJoint jnt : joints) {
            if (jnt != null) continue;
            Console.println((String)"Null VJoint");
        }
        this.targetParts = skeleton.getRoot().getParts(partIdents).toArray(new VObject[partIdents.size()]);
        this.setPartIds(this.targetParts);
        this.setConfigType(configType);
        this.calculateConfigSize();
        this.config = new float[this.configSize];
        this.setConfig(this.config);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.intern();
    }

    private void setPartIds(String[] partIds) {
        this.partIds = partIds;
    }

    public String[] getPartIds() {
        return this.partIds;
    }

    private void setPartIds(VObject[] targets) {
        this.partIds = new String[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            if (targets[i] == null) {
                System.out.println("SkeletonPose.setPartIds, null target for index: " + i);
            }
            this.partIds[i] = targets[i].getId();
        }
    }

    private void calculateConfigSize() {
        this.stride = 0;
        if (this.hasTranslation) {
            this.stride += 3;
        }
        if (this.hasRotation) {
            this.stride += 4;
        }
        if (this.hasScale) {
            this.stride += 3;
        }
        if (this.hasVelocity) {
            this.stride += 3;
        }
        if (this.hasAngularVelocity) {
            this.stride += 3;
        }
        this.configSize = this.stride * this.partIds.length;
        if (this.hasRootTranslation) {
            this.configSize += 3;
        }
    }

    public void setConfig(float[] config) {
        this.config = config;
    }

    public float[] getConfig() {
        return this.config;
    }

    public String getConfigType() {
        return this.configType;
    }

    private void setConfigType(String configType) {
        this.configType = configType;
        this.hasRootTranslation = configType.startsWith("T1");
        if (!this.hasRootTranslation) {
            this.hasTranslation = configType.indexOf(84) >= 0;
        }
        this.hasRotation = configType.indexOf(82) >= 0;
        this.hasScale = configType.indexOf(83) >= 0;
        this.hasVelocity = configType.indexOf(86) >= 0;
        this.hasAngularVelocity = configType.indexOf(87) >= 0;
    }

    private void setRotationEncoding(String rotationEncoding) {
        this.rotationEncoding = rotationEncoding;
    }

    public String getRotationEncoding() {
        return this.rotationEncoding;
    }

    public int getConfigSize() {
        return this.config == null ? 0 : this.config.length;
    }

    public int size() {
        return this.config == null ? 0 : this.config.length;
    }

    public void setTargets(VObject[] targets) {
        this.targetParts = new VObject[this.partIds.length];
        for (int i = 0; i < this.partIds.length; ++i) {
            for (int j = 0; j < targets.length; ++j) {
                if ((targets[j].getId() == null || !targets[j].getId().equals(this.partIds[i])) && (targets[j].getSid() == null || !targets[j].getSid().equals(this.partIds[i]))) continue;
                this.targetParts[i] = targets[j];
                logger.debug("targetParts[{}]={}", (Object)i, (Object)this.partIds[i]);
            }
        }
    }

    public void setToTarget() {
        this.toSkeleton();
    }

    public void toSkeleton() {
        int index = 0;
        if (this.hasRootTranslation && this.targetParts.length > 0) {
            this.targetParts[0].setTranslation(this.config);
            index += 3;
        }
        for (int i = 0; i < this.targetParts.length; ++i) {
            if (this.hasTranslation) {
                this.targetParts[i].setTranslation(this.config, index);
                index += 3;
            }
            if (this.hasRotation) {
                this.targetParts[i].setRotation(this.config, index);
                index += 4;
            }
            if (this.hasScale) {
                this.targetParts[i].setScale(this.config, index);
                index += 3;
            }
            if (this.hasVelocity) {
                this.targetParts[i].setVelocity(this.config, index);
                index += 3;
            }
            if (!this.hasAngularVelocity) continue;
            this.targetParts[i].setAngularVelocity(this.config, index);
            index += 3;
        }
    }

    public void setFromTarget() {
        this.fromSkeleton();
    }

    public void fromSkeleton() {
        int index = 0;
        if (this.hasRootTranslation && this.targetParts.length > 0) {
            this.targetParts[0].getTranslation(this.config);
            index += 3;
        }
        for (int i = 0; i < this.targetParts.length; ++i) {
            if (this.hasTranslation) {
                this.targetParts[i].getTranslation(this.config, index);
                index += 3;
            }
            if (this.hasRotation) {
                this.targetParts[i].getRotation(this.config, index);
                index += 4;
            }
            if (this.hasScale) {
                this.targetParts[i].getScale(this.config, index);
                index += 3;
            }
            if (this.hasVelocity) {
                this.targetParts[i].getVelocity(this.config, index);
                index += 3;
            }
            if (!this.hasAngularVelocity) continue;
            this.targetParts[i].getAngularVelocity(this.config, index);
            index += 3;
        }
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        SkeletonPose.appendAttribute((StringBuilder)buf, (String)"encoding", (String)this.configType);
        SkeletonPose.appendAttribute((StringBuilder)buf, (String)"rotationEncoding", (String)this.rotationEncoding);
        SkeletonPose.appendAttribute((StringBuilder)buf, (String)"parts", (String[])this.partIds, (char)' ', null, (int)60);
        return buf;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        buf.append('\n');
        SkeletonPose.appendSpaces((StringBuilder)buf, (XMLFormatting)fmt);
        buf.append(this.config[0]);
        for (int i = 1; i < this.configSize; ++i) {
            buf.append(' ');
            buf.append(this.config[i]);
        }
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String parts = this.getRequiredAttribute("parts", attrMap, tokenizer);
        this.partIds = SkeletonPose.decodeStringArray((String)parts);
        String encoding = this.getRequiredAttribute("encoding", attrMap, tokenizer);
        this.setConfigType(encoding);
        this.rotationEncoding = this.getOptionalAttribute("rotationEncoding", attrMap, null);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public void decodeContent(XMLTokenizer xmlTokenizer) throws IOException {
        this.calculateConfigSize();
        if (xmlTokenizer.atCharData()) {
            String data = xmlTokenizer.takeCharData();
            StringTokenizer tokenizer = new StringTokenizer(data);
            while (tokenizer.hasMoreTokens()) {
                this.config = new float[this.configSize];
                for (int i = 0; i < this.configSize; ++i) {
                    this.config[i] = (float)Double.parseDouble(tokenizer.nextToken());
                }
            }
            if (this.rotationEncoding != null && this.rotationEncoding.equals("axisangles")) {
                this.convertFromAxisAngles();
            }
        }
    }

    private void convertFromAxisAngles() {
        int startIndex;
        for (int ri = startIndex = this.hasRootTranslation ? 3 : 0; ri < this.configSize; ri += this.stride) {
            Quat4f.setFromAxisAngle4f((float[])this.config, (int)ri, (float[])this.config, (int)ri);
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public void writeBinary(DataOutput dataOut) throws IOException {
        for (int i = 0; i < this.configSize; ++i) {
            dataOut.writeFloat(this.config[i]);
        }
    }

    public void readBinary(DataInput dataIn) throws IOException {
        for (int i = 0; i < this.configSize; ++i) {
            this.config[i] = dataIn.readFloat();
        }
    }
}

