/*
 * Decompiled with CFR 0.152.
 */
package hmi.animation;

import hmi.animation.VJoint;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Skeleton
extends XMLStructureAdapter {
    private String id = "";
    private VJoint root;
    private List<VJoint> roots;
    private List<String> jointSids;
    private List<String> parentSids;
    private List<VJoint> joints;
    private int jointCount = -1;
    private boolean encodeTranslation = true;
    private boolean encodeRotation = false;
    private boolean encodeScale = false;
    private String encoding = "";
    private static Logger logger = LoggerFactory.getLogger((String)"hmi.animation.Skeleton");
    public static boolean HAS_JOINTCOUNT_ATTRIBUTE = true;
    private static final int DEFAULT_MAX_BONE_COUNT = 32;
    public boolean LINE_BASED = true;
    private static final String XMLTAG = "skeleton";

    private Skeleton() {
    }

    public Skeleton(String id) {
        this();
        this.setId(id);
    }

    public Skeleton(String id, VJoint root) {
        this();
        this.setId(id);
        this.setRoot(root);
    }

    public Skeleton(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    private void setId(String id) {
        this.id = id == null ? "" : id.intern();
    }

    public String getId() {
        return this.id;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        if (encoding == null || encoding.equals("") || encoding.equals("T")) {
            this.encodeTranslation = true;
            this.encodeRotation = false;
            this.encodeScale = false;
        } else if (encoding.equals("TR")) {
            this.encodeTranslation = true;
            this.encodeRotation = true;
            this.encodeScale = false;
        } else if (encoding.equals("TRS")) {
            this.encodeTranslation = true;
            this.encodeRotation = true;
            this.encodeScale = true;
        } else {
            System.out.println("Skeleton.setEncoding, unknown/unsupported type: " + encoding);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setRoot(VJoint root) {
        this.root = root;
    }

    public VJoint getRoot() {
        return this.root;
    }

    private int calculateJointCount(VJoint vj) {
        if (vj == null) {
            return 0;
        }
        int result = 1;
        for (VJoint child : vj.getChildren()) {
            result += this.calculateJointCount(child);
        }
        return result;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        Skeleton.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        this.jointCount = this.calculateJointCount(this.root);
        if (HAS_JOINTCOUNT_ATTRIBUTE) {
            Skeleton.appendAttribute((StringBuilder)buf, (String)"jointCount", (int)this.jointCount);
        }
        if (this.encoding != null && !this.encoding.equals("")) {
            Skeleton.appendAttribute((StringBuilder)buf, (String)"encoding", (String)this.encoding);
        }
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.setId(this.getOptionalAttribute("id", attrMap, null));
        this.jointCount = this.getOptionalIntAttribute("jointCount", attrMap, -1);
        this.encoding = this.getOptionalAttribute("encoding", attrMap, "");
        this.setEncoding(this.encoding);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        int tab = fmt.getTab();
        Skeleton.appendSTag((StringBuilder)buf, (String)"bones", (XMLFormatting)fmt);
        if (this.root != null) {
            this.appendVJoint(buf, this.root, fmt.indent());
        }
        Skeleton.appendETag((StringBuilder)buf, (String)"bones", (XMLFormatting)fmt.unIndent());
        return buf;
    }

    private StringBuilder appendVJoint(StringBuilder buf, VJoint vj, XMLFormatting fmt) {
        buf.append('\n');
        Skeleton.appendSpaces((StringBuilder)buf, (XMLFormatting)fmt);
        buf.append(vj.getSid());
        buf.append("   ");
        VJoint parent = vj.getParent();
        buf.append(parent == null ? "null" : parent.getSid());
        if (this.encodeTranslation) {
            buf.append("   ");
            float[] trans = Vec3f.getVec3f();
            vj.getTranslation(trans);
            buf.append(trans[0]);
            buf.append(' ');
            buf.append(trans[1]);
            buf.append(' ');
            buf.append(trans[2]);
        }
        if (this.encodeRotation) {
            buf.append("   ");
            float[] rot = Quat4f.getQuat4f();
            vj.getRotation(rot);
            buf.append(rot[0]);
            buf.append(' ');
            buf.append(rot[1]);
            buf.append(' ');
            buf.append(rot[2]);
            buf.append(' ');
            buf.append(rot[3]);
        }
        if (this.encodeScale) {
            buf.append("   ");
            float[] scal = Vec3f.getVec3f();
            vj.getScale(scal);
            buf.append(scal[0]);
            buf.append(' ');
            buf.append(scal[1]);
            buf.append(' ');
            buf.append(scal[2]);
        }
        for (VJoint child : vj.getChildren()) {
            this.appendVJoint(buf, child, fmt);
        }
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals("bones")) {
                StringTokenizer boneTokenizer;
                StringTokenizer sectionTokenizer;
                tokenizer.takeSTag();
                String boneEncoding = tokenizer.takeOptionalCharData();
                if (this.LINE_BASED) {
                    sectionTokenizer = new StringTokenizer(boneEncoding, "\n\r\f");
                    boneTokenizer = null;
                } else {
                    boneTokenizer = sectionTokenizer = new StringTokenizer(boneEncoding, " \t\n\r\f");
                }
                int listSize = this.jointCount >= 0 ? this.jointCount : 32;
                this.jointSids = new ArrayList<String>(listSize);
                this.joints = new ArrayList<VJoint>(listSize);
                this.parentSids = new ArrayList<String>(listSize);
                int count = 0;
                try {
                    while (sectionTokenizer.hasMoreTokens()) {
                        if (this.LINE_BASED) {
                            String boneLine = sectionTokenizer.nextToken();
                            boneTokenizer = new StringTokenizer(boneLine, " \t\n\r\f");
                        }
                        String jointSid = boneTokenizer.nextToken();
                        if (this.LINE_BASED && jointSid.startsWith("//")) continue;
                        this.jointSids.add(jointSid);
                        VJoint jnt = new VJoint(this.id + "-" + jointSid, jointSid);
                        String parentSid = boneTokenizer.nextToken();
                        this.parentSids.add(parentSid);
                        if (this.encodeTranslation) {
                            float x = Float.parseFloat(boneTokenizer.nextToken());
                            float y = Float.parseFloat(boneTokenizer.nextToken());
                            float z = Float.parseFloat(boneTokenizer.nextToken());
                            jnt.setTranslation(x, y, z);
                        }
                        if (this.encodeRotation) {
                            float s = Float.parseFloat(boneTokenizer.nextToken());
                            float x = Float.parseFloat(boneTokenizer.nextToken());
                            float y = Float.parseFloat(boneTokenizer.nextToken());
                            float z = Float.parseFloat(boneTokenizer.nextToken());
                            jnt.setRotation(s, x, y, z);
                        }
                        if (this.encodeScale) {
                            float sx = Float.parseFloat(boneTokenizer.nextToken());
                            float sy = Float.parseFloat(boneTokenizer.nextToken());
                            float sz = Float.parseFloat(boneTokenizer.nextToken());
                            jnt.setScale(sx, sy, sz);
                        }
                        this.joints.add(jnt);
                        ++count;
                    }
                }
                catch (NoSuchElementException e) {
                    logger.warn(tokenizer.getErrorMessage("Skeleton: incorrect bone encoding: " + boneEncoding));
                }
                if (this.jointCount >= 0 && count != this.jointCount) {
                    System.out.println("Skeleton " + this.id + " count =\"" + this.jointCount + "\" has different number of actual bones: " + count);
                }
                for (int i = 0; i < this.joints.size(); ++i) {
                    String parentSid = this.parentSids.get(i);
                    if (parentSid.equals("null") || parentSid.equals("Null")) {
                        if (this.getRoot() == null) {
                            this.setRoot(this.joints.get(i));
                            continue;
                        }
                        System.out.println("Skeleton " + this.id + " has more than one root: " + this.root.getSid() + ", " + this.joints.get(i).getSid());
                        continue;
                    }
                    boolean foundParent = false;
                    for (VJoint vj : this.joints) {
                        foundParent = vj.getSid().equals(parentSid);
                        if (!foundParent) continue;
                        vj.addChild(this.joints.get(i));
                        break;
                    }
                    if (foundParent) continue;
                    System.out.println("Skeleton " + this.id + " joint " + this.joints.get(i).getSid() + " with unknow parent: " + parentSid);
                }
                tokenizer.takeETag();
                continue;
            }
            logger.warn(tokenizer.getErrorMessage("Skeleton: skip: " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

