/*
 * Decompiled with CFR 0.152.
 */
package hmi.activemq;

import hmi.activemq.JMSRuntimeException;
import hmi.activemq.TextMessageListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler
implements MessageListener,
ExceptionListener {
    private Connection connection = null;
    private Session session = null;
    private MessageProducer messageProducer = null;
    MessageConsumer messageConsumer;
    private Topic topic;
    private String topicName = null;
    private String user = null;
    private String password = null;
    private String url = "failover://tcp://localhost:61616";
    private long timeToLive = 0L;
    private Map<String, Object> messageProperties = null;
    private List<TextMessageListener> msgListeners = new ArrayList<TextMessageListener>();
    private long messagesReceived = 0L;
    private Logger logger = LoggerFactory.getLogger((String)MessageHandler.class.getName());

    public MessageHandler() {
    }

    public MessageHandler(String topicName) {
        this();
        this.setTopic(topicName);
    }

    public synchronized void connect(String url) {
        this.setURL(url);
        this.connect();
    }

    public synchronized void connect() {
        this.logger.info("MessageHander connect to : " + this.url);
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.user, this.password, this.url);
            this.connection = connectionFactory.createConnection();
            this.connection.setExceptionListener((ExceptionListener)this);
            this.session = this.connection.createSession(false, 1);
            this.topic = this.session.createTopic(this.topicName);
            this.messageProducer = this.session.createProducer((Destination)this.topic);
            this.messageProducer.setDeliveryMode(1);
            if (this.timeToLive != 0L) {
                this.messageProducer.setTimeToLive(this.timeToLive);
            }
            this.messageConsumer = this.session.createConsumer((Destination)this.topic);
            this.messageConsumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            this.logger.warn("MessageHandler: ", (Throwable)e);
            throw new JMSRuntimeException((Exception)((Object)e));
        }
    }

    public synchronized void start() {
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            this.logger.warn("MessageHandler: ", (Throwable)e);
            throw new JMSRuntimeException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.connection != null) {
            try {
                if (this.messageProducer != null) {
                    this.messageProducer.close();
                }
                if (this.messageConsumer != null) {
                    this.messageConsumer.close();
                }
                if (this.session != null) {
                    this.session.close();
                }
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.warn("MessageHandler: ", (Throwable)e);
            }
            finally {
                this.messageProducer = null;
                this.messageConsumer = null;
                this.session = null;
                this.connection = null;
            }
        }
    }

    private void addProp(String propName, Object value) {
        if (this.messageProperties == null) {
            this.messageProperties = new LinkedHashMap<String, Object>();
        }
        this.messageProperties.put(propName, value);
    }

    public void addMessageProp(String propName, String value) {
        this.addProp(propName, value);
    }

    public void addMessageProp(String propName, boolean value) {
        this.addProp(propName, value);
    }

    public void addMessageProp(String propName, int value) {
        this.addProp(propName, value);
    }

    public void addMessageProp(String propName, long value) {
        this.addProp(propName, value);
    }

    public void addMessageProp(String propName, float value) {
        this.addProp(propName, Float.valueOf(value));
    }

    public void addMessageProp(String propName, double value) {
        this.addProp(propName, value);
    }

    public synchronized void publish(String msg) {
        try {
            TextMessage message = this.session.createTextMessage(msg);
            if (this.messageProperties != null) {
                for (Map.Entry<String, Object> prop : this.messageProperties.entrySet()) {
                    String propName = prop.getKey();
                    Object propValue = prop.getValue();
                    if (propValue instanceof String) {
                        message.setStringProperty(propName, (String)propValue);
                        continue;
                    }
                    if (propValue instanceof Integer) {
                        message.setLongProperty(propName, (long)((Integer)propValue).intValue());
                        continue;
                    }
                    if (propValue instanceof Long) {
                        message.setLongProperty(propName, ((Long)propValue).longValue());
                        continue;
                    }
                    if (propValue instanceof Boolean) {
                        message.setBooleanProperty(propName, ((Boolean)propValue).booleanValue());
                        continue;
                    }
                    if (propValue instanceof Float) {
                        message.setFloatProperty(propName, ((Float)propValue).floatValue());
                        continue;
                    }
                    if (propValue instanceof Double) {
                        message.setDoubleProperty(propName, ((Double)propValue).doubleValue());
                        continue;
                    }
                    this.logger.warn("MessageHandler, unknown message property type for " + propName);
                }
            }
            this.messageProducer.send((Message)message);
        }
        catch (JMSException e) {
            this.logger.warn("MessageHandler: ", (Throwable)e);
            throw new JMSRuntimeException((Exception)((Object)e));
        }
    }

    public synchronized void addTextMessageListener(TextMessageListener listener) {
        this.msgListeners.add(listener);
    }

    public void onMessage(Message message) {
        ++this.messagesReceived;
        try {
            if (message instanceof TextMessage) {
                TextMessage txtMsg = (TextMessage)message;
                String msg = txtMsg.getText();
                for (TextMessageListener listener : this.msgListeners) {
                    listener.receiveMessage(msg);
                }
            }
        }
        catch (JMSException e) {
            this.logger.warn("MessageHandler: ", (Throwable)e);
            throw new JMSRuntimeException((Exception)((Object)e));
        }
    }

    public synchronized void onException(JMSException e) {
        this.logger.warn("MessageHandler: ", (Throwable)e);
        throw new JMSRuntimeException((Exception)((Object)e));
    }

    public void setTopic(String topicName) {
        this.topicName = topicName;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }
}

