varying vec3 viewVector, lightVector, normalVector, ambient;

varying vec4 diffuseCol;
varying vec4 specularCol;
varying vec4 ambientCol;
varying float specExp;

void main()	
{
	vec3 nV = normalize(normalVector);
	float nDotL = max(dot(lightVector, nV), 0.0);
	vec3 hV = reflect(lightVector,nV);
	float nDotH = max( dot(hV, viewVector), 0.0);
	//gl_FragColor =  vec4(ambient + diffuseCol.rgb * nDotL + 
	//gl_FrontMaterial.specular.rgb * pow(nDotH, gl_FrontMaterial.shininess), gl_FrontMaterial.diffuse.a);
	gl_FragColor = vec4(ambientCol.rgb + diffuseCol.rgb * nDotL + specularCol.rgb * pow(nDotH, specExp), diffuseCol.a);
}