// blinnTextured1.fs
//


varying vec3 ecPosition;
varying vec3 ecNormal;
varying vec4 specularCol;
varying float specExp;
varying vec4 ambientCol;
varying vec4 texCoord;
varying float rr;
varying vec4 col;
uniform float rp;

uniform sampler2D diffuseSampler;

const int numLights = 3;

void main () {

    vec2 midPoint = vec2(0.5, 0.5);
    vec2 tc = texCoord.st - midPoint;
   
    float r = length(tc);
    float r1 = 0.0586;
    float r2 = 0.166;
    //float rp = 0.07;
    
    
    if (r < rp) {
       float f1 = r/rp;  
       float f = f1 * (r1-rp)/r;
       tc =  (1+f) * tc;
   
    } else if (r < r2) {
       float f2 = (r2-r) / (r2-rp);  
       float f = f2 * (r1-rp)/r;
       tc =  (1+f) * tc;
    }
    

  
    vec2  texc = tc + midPoint;
   
	vec3 N = normalize(ecNormal);                                            // normalized normal vector
	vec3 V = normalize(-ecPosition);                                         // normalized view vector	
	vec4 diffuseCol = texture2D(diffuseSampler, texc);
	
	vec4 color =    vec4(0.0, 0.0, 0.0, 0.0);
	vec4 diffuse =  vec4(0.0, 0.0, 0.0, 0.0);
	vec4 specular = vec4(0.0, 0.0, 0.0, 0.0);
	//vec4 ambient =  vec4(0.0, 0.0, 0.0, 0.0);
	float intensity = 0.0;
	
	for(int i = 0; i < numLights; i++) {
      vec3 LV = vec3(gl_LightSource[i].position) - ecPosition;      
	   vec3 L = normalize(LV); 
	   
	   vec3 H = normalize(L + V);
	   intensity = max(dot(N, L), 0.0);
	   if (intensity > 0.0) {
	      float d = length(LV);
	      float attenuation = 1.0 / (1.0 + gl_LightSource[i].linearAttenuation * d);
	      intensity *= attenuation;
	      diffuse = intensity * diffuseCol * gl_LightSource[i].diffuse;
	      
	      specular =  pow(max(dot(H, N), 0.0), specExp) * specularCol * gl_LightSource[i].specular;
	  
         color += (diffuse + specular) * attenuation;
	   }
	   
   }
   
  
    
 
   
  
	gl_FragColor = vec4(color.rgb, diffuseCol.a);
	//gl_FragColor = fcol;
	
	//float att = clamp((1.0 - 3.0*rr), 0.0, 1.0);
	
	//gl_FragColor = att * vec4(1.0, 0.0, 0.0, 1.0);
	
}