// basic Blinn-Phong shader

varying vec3 ecPosition;
varying vec3 ecNormal;
varying vec4 diffuseCol;
varying vec4 specularCol;
varying float specExp;
varying vec4 ambientCol;
const int numLights = 3;

void main () {
	vec3 N = normalize(ecNormal);                                            // normalized normal vector
	vec3 V = normalize(-ecPosition);                                         // normalized view vector
	
   vec4 color =    vec4(0.0, 0.0, 0.0, 0.0);
   vec4 diffuse =  vec4(0.0, 0.0, 0.0, 0.0);
   vec4 specular = vec4(0.0, 0.0, 0.0, 0.0);
   //vec4 ambient =  vec4(0.0, 0.0, 0.0, 0.0);
   float intensity = 0.0;

	for(int i = 0; i < numLights; i++) {
	   vec3 LV = vec3(gl_LightSource[i].position) - ecPosition;       // normalized light vector
	   vec3 L = normalize(LV);
	   vec3 H = normalize(L + V);	
	   intensity = max(dot(N, L), 0.0);
	   if (intensity > 0.0) {
	      float d = length(LV);
	      float attenuation = 1.0 / (1.0 + gl_LightSource[i].linearAttenuation * d);
	      
	      diffuse = intensity * diffuseCol * gl_LightSource[i].diffuse;
	      specular =  pow(max(dot(H, N), 0.0), specExp) * specularCol * gl_LightSource[i].specular;
	      color +=  (diffuse + specular) * attenuation;
	   }
	   //ambient = ambientCol * gl_LightSource[i].ambient;
      
   }

	gl_FragColor = vec4(color.rgb, diffuseCol.a);
}
