/*
 * Decompiled with CFR 0.152.
 */
package asap.utils;

import asap.utils.AnimationSync;
import asap.utils.CopyEmbodiment;
import asap.utils.CopyEnvironment;
import hmi.util.ClockListener;
import hmi.util.SystemClock;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockDrivenCopyEnvironment
implements CopyEnvironment,
ClockListener {
    private static final Logger log = LoggerFactory.getLogger(ClockDrivenCopyEnvironment.class);
    private String id = null;
    private SystemClock theClock = null;
    private boolean isShutdown = false;
    @GuardedBy(value="itself")
    private Set<CopyEmbodiment> copyEmbodiments = new HashSet<CopyEmbodiment>();
    private long tickSize;

    public ClockDrivenCopyEnvironment(long tickSize) {
        this.tickSize = tickSize;
    }

    public void initTime(double initTime) {
        this.copy();
    }

    public void time(double currentTime) {
        this.copy();
    }

    @Override
    public void requestShutdown() {
        this.theClock.terminate();
        this.isShutdown = true;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy() {
        Object object = AnimationSync.getSync();
        synchronized (object) {
            Set<CopyEmbodiment> set = this.copyEmbodiments;
            synchronized (set) {
                for (CopyEmbodiment ce : this.copyEmbodiments) {
                    ce.copy();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCopyEmbodiment(CopyEmbodiment ce) {
        Set<CopyEmbodiment> set = this.copyEmbodiments;
        synchronized (set) {
            this.copyEmbodiments.add(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCopyEmbodiment(CopyEmbodiment ce) {
        Set<CopyEmbodiment> set = this.copyEmbodiments;
        synchronized (set) {
            this.copyEmbodiments.remove(ce);
        }
    }

    public void init() {
        this.theClock = new SystemClock(this.tickSize);
        this.theClock.addClockListener((ClockListener)this);
        this.theClock.start();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

