/*
 * Decompiled with CFR 0.152.
 */
package asap.environment.impl;

import asap.environment.AsapVirtualHuman;
import asap.environment.EmbodimentLoader;
import asap.environment.Loader;
import asap.environment.impl.JComponentEmbodiment;
import asap.utils.Embodiment;
import asap.utils.Environment;
import hmi.bml.bridge.TCPIPToBMLRealizerAdapter;
import hmi.bml.bridge.ui.BridgeServerUI;
import hmi.bml.bridge.ui.FeedbackPanel;
import hmi.bml.bridge.ui.RealizerBridgeUI;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFrameEmbodiment
implements JComponentEmbodiment,
EmbodimentLoader {
    private Logger logger = LoggerFactory.getLogger((String)JFrameEmbodiment.class.getName());
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private AsapVirtualHuman theVirtualHuman = null;
    private JButton killVH;
    private JFrame theUI = null;
    private JPanel contentPanel;
    private String id = "";

    public JFrameEmbodiment() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFrameEmbodiment.this.contentPanel = new JPanel();
                }
            });
        }
        catch (InterruptedException e) {
            this.logger.warn("Exception constructing contentPanel", (Throwable)e);
            Thread.interrupted();
        }
        catch (InvocationTargetException e) {
            this.logger.warn("Exception constructing contentPanel", (Throwable)e);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void readXML(XMLTokenizer tokenizer, String newId, AsapVirtualHuman avh, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.setId(newId);
        this.theVirtualHuman = avh;
        final XMLTokenizer tok = tokenizer;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFrameEmbodiment.this.theUI = new JFrame(JFrameEmbodiment.this.theVirtualHuman.getName());
                    JFrameEmbodiment.this.theUI.setLocation(650, 50);
                    JFrameEmbodiment.this.theUI.setSize(600, 500);
                    JFrameEmbodiment.this.theUI.setDefaultCloseOperation(0);
                    JFrameEmbodiment.this.theUI.setVisible(true);
                    JFrameEmbodiment.this.contentPanel.setLayout(new BoxLayout(JFrameEmbodiment.this.contentPanel, 3));
                    JFrameEmbodiment.this.contentPanel.setAlignmentX(0.0f);
                    JFrameEmbodiment.this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    JFrameEmbodiment.this.theUI.getContentPane().add(JFrameEmbodiment.this.contentPanel);
                    try {
                        while (!tok.atETag("Loader")) {
                            JFrameEmbodiment.this.readSection(tok);
                        }
                    }
                    catch (IOException e) {
                        JFrameEmbodiment.this.logger.warn("IOException reading section", (Throwable)e);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            this.logger.warn("Exception JFrameEmbodiment from XML", (Throwable)e);
            Thread.interrupted();
        }
        catch (InvocationTargetException e) {
            this.logger.warn("Exception JFrameEmbodiment from XML", (Throwable)e);
        }
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("ServerUI")) {
            TCPIPToBMLRealizerAdapter theServer = this.theVirtualHuman.getTcpipToBMLRealizerAdapter();
            BridgeServerUI bsui = null;
            bsui = theServer == null ? new BridgeServerUI(this.theVirtualHuman.getRealizerPort(), 7521, 1257) : new BridgeServerUI(this.theVirtualHuman.getRealizerPort(), theServer);
            this.addJComponent((JComponent)bsui);
            tokenizer.takeSTag("ServerUI");
            tokenizer.takeETag("ServerUI");
        } else if (tokenizer.atSTag("BmlUI")) {
            attrMap = tokenizer.getAttributes();
            String demoscriptdir = this.adapter.getOptionalAttribute("demoscriptresources", attrMap, "bml/defaultexamples");
            this.addJComponent((JComponent)new RealizerBridgeUI(this.theVirtualHuman.getRealizerPort(), demoscriptdir));
            tokenizer.takeSTag("BmlUI");
            tokenizer.takeETag("BmlUI");
        } else if (tokenizer.atSTag("FeedbackUI")) {
            this.addJComponent((JComponent)new FeedbackPanel(this.theVirtualHuman.getRealizerPort()));
            tokenizer.takeSTag("FeedbackUI");
            tokenizer.takeETag("FeedbackUI");
        } else if (tokenizer.atSTag("KillButton")) {
            this.killVH = new JButton("KILL VH");
            this.killVH.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFrameEmbodiment.this.theVirtualHuman.unload();
                }
            });
            this.addJComponent(this.killVH);
            tokenizer.takeSTag("KillButton");
            tokenizer.takeETag("KillButton");
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
    }

    @Override
    public void unload() {
        this.pullThePlug();
    }

    @Override
    public void addJComponent(JComponent jc) {
        jc.setAlignmentX(0.0f);
        this.contentPanel.add(jc);
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    @Override
    public void removeJComponent(JComponent jc) {
        this.contentPanel.remove(jc);
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    @Override
    public Embodiment getEmbodiment() {
        return this;
    }

    public void pullThePlug() {
        this.theUI.setDefaultCloseOperation(2);
        WindowEvent wev = new WindowEvent(this.theUI, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
    }
}

