/*
 * Decompiled with CFR 0.152.
 */
package asap.environment;

import asap.environment.AsapEnvironment;
import asap.environment.BMLParserAssembler;
import asap.environment.BMLSchedulerAssembler;
import asap.environment.EngineLoader;
import asap.environment.Loader;
import asap.environment.impl.ActivateEngineLoader;
import asap.environment.impl.InterruptEngineLoader;
import asap.environment.impl.ParameterValueChangeEngineLoader;
import asap.environment.impl.WaitEngineLoader;
import asap.utils.Environment;
import asap.utils.SchedulingClock;
import com.google.common.collect.ImmutableSet;
import hmi.bml.bridge.RealizerPort;
import hmi.bml.bridge.TCPIPToBMLRealizerAdapter;
import hmi.bml.core.Behaviour;
import hmi.bml.ext.bmlt.BMLTBMLBehaviorAttributes;
import hmi.bml.parser.BMLParser;
import hmi.elckerlyc.ElckerlycRealizer;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.bridge.LogPipe;
import hmi.elckerlyc.bridge.MultiThreadedElckerlycRealizerBridge;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.FeedbackManagerImpl;
import hmi.elckerlyc.pegboard.PegBoard;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.BMLTSchedulingHandler;
import hmi.elckerlyc.scheduler.SchedulingHandler;
import hmi.elckerlyc.scheduler.SchedulingStrategy;
import hmi.elckerlyc.scheduler.SortedSmartBodySchedulingStrategy;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsapVirtualHuman {
    private Logger logger = LoggerFactory.getLogger((String)AsapVirtualHuman.class.getName());
    private ElckerlycRealizer elckerlycRealizer = null;
    private RealizerPort realizerPort = null;
    private TCPIPToBMLRealizerAdapter tcpipToBMLRealizerAdapter = null;
    private BMLScheduler bmlScheduler = null;
    private String name = "<no name>";
    private String id = "";
    private ArrayList<Engine> engines = new ArrayList();
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private HashMap<String, String> attrMap = null;
    private XMLTokenizer theTokenizer = null;
    private HashMap<String, Loader> loaders = new HashMap();
    private AsapEnvironment ae = null;
    private Environment[] allEnvironments = new Environment[0];
    private SchedulingClock theSchedulingClock = null;
    private final PegBoard pegBoard = new PegBoard();

    public void unload() {
        this.ae.removeVirtualHuman(this);
        if (this.tcpipToBMLRealizerAdapter != null) {
            this.tcpipToBMLRealizerAdapter.shutdown();
            this.logger.debug("Attempting to shutdown server...");
        }
        this.elckerlycRealizer.shutdown();
        for (Map.Entry<String, Loader> loader : this.loaders.entrySet()) {
            loader.getValue().unload();
        }
    }

    public void load(String resources, String filename, String name, Environment[] environments, SchedulingClock sc) throws IOException {
        this.load(XMLTokenizer.forResource((String)resources, (String)filename), name, environments, sc);
    }

    public void load(XMLTokenizer tokenizer, String name, Environment[] environments, SchedulingClock sc) throws IOException {
        for (Environment e : environments) {
            if (!(e instanceof AsapEnvironment)) continue;
            this.ae = (AsapEnvironment)e;
        }
        if (this.ae == null) {
            throw new RuntimeException("AsapVirtualHuman requires an AsapEnvironment when loading");
        }
        this.theTokenizer = tokenizer;
        this.allEnvironments = environments;
        this.theSchedulingClock = sc;
        this.name = name;
        try {
            this.theTokenizer.takeSTag("AsapVirtualHuman");
            this.loadBMLRealizerSection();
            Loader loader = null;
            while (this.theTokenizer.atSTag("Loader")) {
                this.attrMap = this.theTokenizer.getAttributes();
                String id = this.adapter.getRequiredAttribute("id", this.attrMap, this.theTokenizer);
                String loaderClass = this.adapter.getRequiredAttribute("loader", this.attrMap, this.theTokenizer);
                String requiredLoaderIds = this.adapter.getOptionalAttribute("requiredloaders", this.attrMap, "");
                ArrayList<Loader> requiredLoaders = new ArrayList<Loader>();
                if (!requiredLoaderIds.equals("")) {
                    for (String reqId : requiredLoaderIds.split(",")) {
                        if (!reqId.equals("") && this.loaders.get(reqId) == null) {
                            throw this.theTokenizer.getXMLScanException("Required loader not present: " + reqId);
                        }
                        requiredLoaders.add(this.loaders.get(reqId));
                    }
                }
                try {
                    loader = (Loader)Class.forName(loaderClass).newInstance();
                }
                catch (InstantiationException e) {
                    throw this.theTokenizer.getXMLScanException("InstantiationException while starting Loader " + loaderClass);
                }
                catch (IllegalAccessException e) {
                    throw this.theTokenizer.getXMLScanException("IllegalAccessException while starting Loader " + loaderClass);
                }
                catch (ClassNotFoundException e) {
                    throw this.theTokenizer.getXMLScanException("ClassNotFoundException while starting Loader " + loaderClass);
                }
                catch (ClassCastException e) {
                    throw this.theTokenizer.getXMLScanException("ClassCastException while starting Loader " + loaderClass);
                }
                this.theTokenizer.takeSTag("Loader");
                this.logger.debug("Parsing Loader: {}", (Object)id);
                loader.readXML(this.theTokenizer, id, this, this.allEnvironments, requiredLoaders.toArray(new Loader[0]));
                this.theTokenizer.takeETag("Loader");
                this.loaders.put(id, loader);
                if (!(loader instanceof EngineLoader)) continue;
                this.engines.add(((EngineLoader)loader).getEngine());
            }
            if (this.theTokenizer.atSTag("BMLRouting")) {
                this.loadBMLRoutingSection();
            }
            this.theTokenizer.takeETag("AsapVirtualHuman");
            String id = "waitengine";
            loader = new WaitEngineLoader();
            loader.readXML(null, id, this, this.allEnvironments, new Loader[0]);
            this.loaders.put(id, loader);
            this.engines.add(((EngineLoader)loader).getEngine());
            id = "parametervaluechangeengine";
            loader = new ParameterValueChangeEngineLoader();
            loader.readXML(null, id, this, this.allEnvironments, new Loader[0]);
            this.loaders.put(id, loader);
            this.engines.add(((EngineLoader)loader).getEngine());
            id = "activateengine";
            loader = new ActivateEngineLoader();
            loader.readXML(null, id, this, this.allEnvironments, new Loader[0]);
            this.loaders.put(id, loader);
            this.engines.add(((EngineLoader)loader).getEngine());
            id = "interruptengine";
            loader = new InterruptEngineLoader();
            loader.readXML(null, id, this, this.allEnvironments, new Loader[0]);
            this.loaders.put(id, loader);
            this.engines.add(((EngineLoader)loader).getEngine());
            this.ae.addVirtualHuman(this);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void loadBMLRealizerSection() throws IOException {
        this.attrMap = this.theTokenizer.getAttributes();
        this.theTokenizer.takeSTag("BMLRealizer");
        BMLParser parser = this.readParserSection();
        BMLBlockManager bmlBlockManager = new BMLBlockManager();
        FeedbackManagerImpl feedbackManager = new FeedbackManagerImpl(bmlBlockManager, this.name);
        this.bmlScheduler = this.readSchedulerSection(bmlBlockManager, parser, (FeedbackManager)feedbackManager);
        this.elckerlycRealizer = new ElckerlycRealizer(parser, (FeedbackManager)feedbackManager, this.theSchedulingClock, this.bmlScheduler, new Engine[0]);
        this.realizerPort = new MultiThreadedElckerlycRealizerBridge(this.elckerlycRealizer);
        while (!this.theTokenizer.atETag("BMLRealizer")) {
            this.readBMLRealizerSubsection();
        }
        this.theTokenizer.takeETag("BMLRealizer");
    }

    protected BMLParser readParserSection() throws IOException {
        BMLParser parser = new BMLParser(new ImmutableSet.Builder().add(BMLTBMLBehaviorAttributes.class).build());
        if (this.theTokenizer.atSTag("BMLParser")) {
            BMLParserAssembler assembler = new BMLParserAssembler();
            assembler.readXML(this.theTokenizer);
            parser = assembler.getBMLParser();
        }
        return parser;
    }

    protected BMLScheduler readSchedulerSection(BMLBlockManager bmlBlockManager, BMLParser parser, FeedbackManager feedbackManager) throws IOException {
        BMLScheduler scheduler;
        if (this.theTokenizer.atSTag("BMLScheduler")) {
            BMLSchedulerAssembler assembler = new BMLSchedulerAssembler(this.name, parser, feedbackManager, bmlBlockManager, this.theSchedulingClock, this.pegBoard);
            assembler.readXML(this.theTokenizer);
            scheduler = assembler.getBMLScheduler();
        } else {
            scheduler = new BMLScheduler(this.name, parser, feedbackManager, this.theSchedulingClock, (SchedulingHandler)new BMLTSchedulingHandler((SchedulingStrategy)new SortedSmartBodySchedulingStrategy(this.pegBoard)), bmlBlockManager, this.pegBoard);
        }
        return scheduler;
    }

    protected void readBMLRealizerSubsection() throws IOException {
        if (this.theTokenizer.atSTag("ServerAdapter")) {
            this.attrMap = this.theTokenizer.getAttributes();
            String requestPort = this.adapter.getRequiredAttribute("requestport", this.attrMap, this.theTokenizer);
            String feedbackPort = this.adapter.getRequiredAttribute("feedbackport", this.attrMap, this.theTokenizer);
            this.tcpipToBMLRealizerAdapter = new TCPIPToBMLRealizerAdapter(this.realizerPort, Integer.valueOf(requestPort).intValue(), Integer.valueOf(feedbackPort).intValue());
            this.theTokenizer.takeSTag("ServerAdapter");
            this.theTokenizer.takeETag("ServerAdapter");
        } else if (this.theTokenizer.atSTag("Scheduler")) {
            this.logger.error("Encountered Scheduler section that was not at beginning of BMLRealizer section");
        } else if (this.theTokenizer.atSTag("LogPipe")) {
            this.attrMap = this.theTokenizer.getAttributes();
            String requestLog = this.adapter.getOptionalAttribute("requestlog", this.attrMap);
            String feedbackLog = this.adapter.getOptionalAttribute("feedbacklog", this.attrMap);
            Logger rl = null;
            Logger fl = null;
            if (requestLog != null) {
                rl = LoggerFactory.getLogger((String)requestLog);
            }
            if (feedbackLog != null) {
                fl = LoggerFactory.getLogger((String)feedbackLog);
            }
            this.realizerPort = new LogPipe(rl, fl, this.realizerPort, this.theSchedulingClock);
            this.theTokenizer.takeSTag("LogPipe");
            this.theTokenizer.takeETag("LogPipe");
        } else {
            throw this.theTokenizer.getXMLScanException("Unknown tag in BMLRealizer content");
        }
    }

    private void loadBMLRoutingSection() throws IOException {
        this.attrMap = this.theTokenizer.getAttributes();
        this.theTokenizer.takeSTag("BMLRouting");
        while (this.theTokenizer.atSTag("Route")) {
            this.attrMap = this.theTokenizer.getAttributes();
            String behaviorClassName = this.adapter.getRequiredAttribute("behaviourclass", this.attrMap, this.theTokenizer);
            String engineId = this.adapter.getRequiredAttribute("engineid", this.attrMap, this.theTokenizer);
            Engine engine = null;
            for (Engine e : this.engines) {
                if (!e.getId().equals(engineId)) continue;
                engine = e;
                break;
            }
            if (engine == null) {
                this.logger.error("Cannot find engine with id \"{}\"", (Object)engineId);
            } else {
                try {
                    Class<?> behaviorClass = Class.forName(behaviorClassName);
                    if (Behaviour.class.isAssignableFrom(behaviorClass)) {
                        this.elckerlycRealizer.addEngine(behaviorClass, engine);
                    } else {
                        this.logger.error("The class \"{}\" is not a bml Behaviour class", (Object)behaviorClassName);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Cannot find behaviorclass \"{}\"", (Object)behaviorClassName);
                    this.logger.debug("Exception: ", (Throwable)e);
                }
            }
            this.theTokenizer.takeSTag("Route");
            this.theTokenizer.takeETag("Route");
        }
        this.theTokenizer.takeETag("BMLRouting");
    }

    public ElckerlycRealizer getElckerlycRealizer() {
        return this.elckerlycRealizer;
    }

    protected void setElckerlycRealizer(ElckerlycRealizer elckerlycRealizer) {
        this.elckerlycRealizer = elckerlycRealizer;
    }

    public RealizerPort getRealizerPort() {
        return this.realizerPort;
    }

    protected void setRealizerPort(RealizerPort realizerPort) {
        this.realizerPort = realizerPort;
    }

    public TCPIPToBMLRealizerAdapter getTcpipToBMLRealizerAdapter() {
        return this.tcpipToBMLRealizerAdapter;
    }

    protected void setTcpipToBMLRealizerAdapter(TCPIPToBMLRealizerAdapter tcpipToBMLRealizerAdapter) {
        this.tcpipToBMLRealizerAdapter = tcpipToBMLRealizerAdapter;
    }

    public BMLScheduler getBmlScheduler() {
        return this.bmlScheduler;
    }

    protected void setBmlScheduler(BMLScheduler bmlScheduler) {
        this.bmlScheduler = bmlScheduler;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public ArrayList<Engine> getEngines() {
        return this.engines;
    }

    protected void setEngines(ArrayList<Engine> engines) {
        this.engines = engines;
    }

    public HashMap<String, Loader> getLoaders() {
        return this.loaders;
    }

    public PegBoard getPegBoard() {
        return this.pegBoard;
    }
}

