/*
 * Decompiled with CFR 0.152.
 */
package asap.environment;

import asap.environment.AsapVirtualHuman;
import asap.utils.Environment;
import asap.utils.SchedulingClock;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.world.WorldObjectManager;
import hmi.util.ClockListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsapEnvironment
implements Environment,
ClockListener {
    String id = "elckerlycenvironment";
    private Logger logger = LoggerFactory.getLogger((String)AsapEnvironment.class.getName());
    protected HashMap<String, AsapVirtualHuman> virtualHumans = new HashMap();
    protected Environment[] environments = new Environment[0];
    protected ArrayList<Engine> engines = new ArrayList();
    protected SchedulingClock schedulingClock;
    WorldObjectManager worldObjectManager = new WorldObjectManager();
    @GuardedBy(value="itself")
    protected List<Runnable> asapRunners = Collections.synchronizedList(new ArrayList());
    protected Object shutdownSync = new Object();
    protected volatile boolean shutdownPrepared = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ArrayList<Environment> environments, SchedulingClock schedulingClock) {
        this.logger.debug("Initializing AsapEnvironment");
        Object object = this.shutdownSync;
        synchronized (object) {
            if (this.shutdownPrepared) {
                return;
            }
            if (!environments.contains(this)) {
                environments.add(this);
            }
            this.environments = new Environment[environments.size()];
            for (int i = 0; i < environments.size(); ++i) {
                this.environments[i] = environments.get(i);
            }
            this.schedulingClock = schedulingClock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(double currentTime) {
        Object object = this.shutdownSync;
        synchronized (object) {
            if (this.shutdownPrepared) {
                return;
            }
            for (Engine e : this.engines) {
                e.play(currentTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTime(double currentTime) {
        Object object = this.shutdownSync;
        synchronized (object) {
            if (this.shutdownPrepared) {
                return;
            }
            for (Engine e : this.engines) {
                e.play(currentTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsapVirtualHuman loadVirtualHuman(String id, String resources, String fileName, String name) throws IOException {
        Object object = this.shutdownSync;
        synchronized (object) {
            if (this.shutdownPrepared) {
                return null;
            }
            if (this.virtualHumans.containsKey(id)) {
                throw new RuntimeException("Duplicate id for virtual human!");
            }
            AsapVirtualHuman avh = new AsapVirtualHuman();
            avh.setId(id);
            avh.load(resources, fileName, name, this.environments, this.schedulingClock);
            return avh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVirtualHuman(AsapVirtualHuman avh) {
        Object object = this.shutdownSync;
        synchronized (object) {
            if (this.shutdownPrepared) {
                return;
            }
            HashMap<String, AsapVirtualHuman> hashMap = this.virtualHumans;
            synchronized (hashMap) {
                this.virtualHumans.put(avh.getId(), avh);
                this.engines.addAll(avh.getEngines());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVirtualHuman(AsapVirtualHuman avh) {
        Object object = this.shutdownSync;
        synchronized (object) {
            if (this.shutdownPrepared) {
                return;
            }
            HashMap<String, AsapVirtualHuman> hashMap = this.virtualHumans;
            synchronized (hashMap) {
                this.virtualHumans.remove(avh.getId());
                this.engines.removeAll(avh.getEngines());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllVirtualHumans() {
        Object object = this.shutdownSync;
        synchronized (object) {
            if (this.shutdownPrepared) {
                return;
            }
            ArrayList<AsapVirtualHuman> vhList = new ArrayList<AsapVirtualHuman>();
            vhList.addAll(this.virtualHumans.values());
            for (AsapVirtualHuman avh : vhList) {
                this.logger.info("Disposing humanoid {}", (Object)avh.getName());
                avh.unload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        Object object = this.shutdownSync;
        synchronized (object) {
            if (this.shutdownPrepared) {
                return;
            }
            for (AsapVirtualHuman vh : this.virtualHumans.values()) {
                vh.getRealizerPort().performBML("<bml id=\"clear\" composition=\"replace\"></bml>");
            }
            for (Engine e : this.engines) {
                e.play(0.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestShutdown() {
        Object object = this.shutdownSync;
        synchronized (object) {
            if (this.shutdownPrepared) {
                return;
            }
            this.logger.info("Prepare shutdown of AsapEnvironment...");
            this.logger.info("Unload all Virtual Humans...");
            this.unloadAllVirtualHumans();
            this.logger.debug("Virtual Humans unloaded");
            this.logger.info("Prepare shutdown of all environments...");
            for (Environment e : this.environments) {
                this.logger.debug("Shutting down " + e.getClass());
                if (e == this) continue;
                e.requestShutdown();
            }
            this.shutdownPrepared = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Object object = this.shutdownSync;
        synchronized (object) {
            for (Environment e : this.environments) {
                if (e == this || e.isShutdown()) continue;
                return false;
            }
            return true;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorldObjectManager getWorldObjectManager() {
        return this.worldObjectManager;
    }
}

