/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.feedback;

import org.junit.Assert;
import org.junit.Test;
import saiba.bml.feedback.BMLSyncPointProgressFeedback;

public class BMLSyncPointProgressFeedbackTest {
    private static final double PRECISION = 1.0E-5;

    @Test
    public void testReadXML() {
        String str = "<syncPointProgress characterId=\"doctor\" id=\"bml1:gesture1:stroke\" time=\"10\" globalTime=\"111\"/>";
        BMLSyncPointProgressFeedback progress = new BMLSyncPointProgressFeedback();
        progress.readXML(str);
        Assert.assertEquals((Object)"doctor", (Object)progress.getCharacterId());
        Assert.assertEquals((double)10.0, (double)progress.getTime(), (double)1.0E-5);
        Assert.assertEquals((double)111.0, (double)progress.getGlobalTime(), (double)1.0E-5);
    }

    @Test
    public void testWriteXML() {
        String str = "<syncPointProgress characterId=\"doctor\" id=\"bml1:gesture1:stroke\" time=\"10\" globalTime=\"111\"/>";
        BMLSyncPointProgressFeedback progressIn = new BMLSyncPointProgressFeedback();
        progressIn.readXML(str);
        StringBuilder buf = new StringBuilder();
        progressIn.appendXML(buf);
        BMLSyncPointProgressFeedback progressOut = new BMLSyncPointProgressFeedback();
        progressOut.readXML(buf.toString());
        Assert.assertEquals((Object)"doctor", (Object)progressOut.getCharacterId());
        Assert.assertEquals((double)10.0, (double)progressOut.getTime(), (double)1.0E-5);
        Assert.assertEquals((double)111.0, (double)progressOut.getGlobalTime(), (double)1.0E-5);
    }

    @Test
    public void testWriteXMLNoCharacterId() {
        String str = "<syncPointProgress id=\"bml1:gesture1:stroke\" time=\"10\" globalTime=\"111\"/>";
        BMLSyncPointProgressFeedback progressIn = new BMLSyncPointProgressFeedback();
        progressIn.readXML(str);
        StringBuilder buf = new StringBuilder();
        progressIn.appendXML(buf);
        BMLSyncPointProgressFeedback progressOut = new BMLSyncPointProgressFeedback();
        progressOut.readXML(buf.toString());
        Assert.assertNull((Object)progressOut.getCharacterId());
        Assert.assertEquals((double)10.0, (double)progressOut.getTime(), (double)1.0E-5);
        Assert.assertEquals((double)111.0, (double)progressOut.getGlobalTime(), (double)1.0E-5);
    }
}

