/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.feedback;

import org.junit.Assert;
import org.junit.Test;
import saiba.bml.feedback.BMLBlockProgressFeedback;

public class BMLBlockProgressFeedbackTest {
    private static final double PRECISION = 1.0E-5;

    @Test
    public void testReadXML() {
        String str = "<blockProgress id=\"bml1:start\" globalTime=\"10\" characterId=\"doctor\"/>";
        BMLBlockProgressFeedback progress = new BMLBlockProgressFeedback();
        progress.readXML(str);
        Assert.assertEquals((Object)"bml1", (Object)progress.getBmlId());
        Assert.assertEquals((Object)"start", (Object)progress.getSyncId());
        Assert.assertEquals((double)10.0, (double)progress.getGlobalTime(), (double)1.0E-5);
        Assert.assertEquals((Object)"doctor", (Object)progress.getCharacterId());
    }

    @Test
    public void testWriteXML() {
        String str = "<blockProgress id=\"bml1:start\" globalTime=\"10\" characterId=\"doctor\"/>";
        BMLBlockProgressFeedback progressIn = new BMLBlockProgressFeedback();
        progressIn.readXML(str);
        StringBuilder buf = new StringBuilder();
        progressIn.appendXML(buf);
        BMLBlockProgressFeedback progressOut = new BMLBlockProgressFeedback();
        progressOut.readXML(buf.toString());
        Assert.assertEquals((Object)"bml1", (Object)progressOut.getBmlId());
        Assert.assertEquals((Object)"start", (Object)progressOut.getSyncId());
        Assert.assertEquals((double)10.0, (double)progressOut.getGlobalTime(), (double)1.0E-5);
        Assert.assertEquals((Object)"doctor", (Object)progressOut.getCharacterId());
    }
}

