/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.feedback;

import hmi.xml.XMLScanException;
import java.io.IOException;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;
import saiba.bml.feedback.BMLBlockPredictionFeedback;

public class BMLBlockPredictionFeedbackTest {
    private static final double TIME_PRECISION = 1.0E-4;

    @Test
    public void testReadXML() {
        BMLBlockPredictionFeedback fb = new BMLBlockPredictionFeedback();
        String str = "<bml id=\"bml1\" globalStart=\"1\" globalEnd=\"2\"/>";
        fb.readXML(str);
        Assert.assertEquals((Object)"bml1", (Object)fb.getId());
        Assert.assertEquals((double)1.0, (double)fb.getGlobalStart(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)fb.getGlobalEnd(), (double)1.0E-4);
    }

    @Test(expected=XMLScanException.class)
    public void testEndOrStartRequired() {
        BMLBlockPredictionFeedback fb = new BMLBlockPredictionFeedback();
        String str = "<bml id=\"bml1\"/>";
        fb.readXML(str);
    }

    @Test
    public void testWriteXML() throws SAXException, IOException {
        BMLBlockPredictionFeedback fb = new BMLBlockPredictionFeedback("bml1", 1.0, 2.0);
        StringBuilder buf = new StringBuilder();
        fb.appendXML(buf);
        XMLAssert.assertXMLEqual((String)"<bml id=\"bml1\" globalStart=\"1.0\" globalEnd=\"2.0\"/>", (String)buf.toString());
    }
}

