/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core.ext;

import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.core.ext.FaceFacsBehaviour;

public class FaceFacsBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    @Test
    public void testReadXML() throws IOException {
        String str = "<faceFacs id=\"face1\" xmlns=\"http://www.bml-initiative.org/bml/coreextensions-1.0\" amount=\"0.25\" start=\"1\" au=\"1\" side=\"BOTH\" />";
        FaceFacsBehaviour beh = new FaceFacsBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"face1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.getBmlId());
        Assert.assertEquals((Object)"BOTH", (Object)beh.getStringParameterValue("side"));
        Assert.assertEquals((double)1.0, (double)beh.getFloatParameterValue("au"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void testWriteXML() throws IOException {
        String str = "<faceFacs id=\"face1\" xmlns=\"http://www.bml-initiative.org/bml/coreextensions-1.0\" amount=\"0.25\" start=\"1\" au=\"1\" side=\"BOTH\" />";
        FaceFacsBehaviour behIn = new FaceFacsBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf, new XMLFormatting(), "xmlns", "http://www.bml-initiative.org/bml/coreextensions-1.0");
        behIn.appendXML(buf);
        FaceFacsBehaviour behOut = new FaceFacsBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"face1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.getBmlId());
        Assert.assertEquals((Object)"BOTH", (Object)behOut.getStringParameterValue("side"));
        Assert.assertEquals((double)1.0, (double)behOut.getFloatParameterValue("au"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

