/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.core.AbstractBehaviourTest;
import saiba.bml.core.Behaviour;
import saiba.bml.core.WaitBehaviour;

public class WaitBehaviourTest
extends AbstractBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    protected Behaviour createBehaviour(String bmlId, String extraAttributeString) throws IOException {
        String str = "<wait id=\"wait1\" " + extraAttributeString + " max-wait=\"2\"/>";
        return new WaitBehaviour("bml1", new XMLTokenizer(str));
    }

    protected Behaviour parseBehaviour(String bmlId, String bmlString) throws IOException {
        return new WaitBehaviour("bml1", new XMLTokenizer(bmlString));
    }

    @Test
    public void testReadXML() throws IOException {
        String str = "<wait id=\"wait1\" start=\"1\" max-wait=\"2\"/>";
        WaitBehaviour beh = new WaitBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"wait1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((double)2.0, (double)beh.getFloatParameterValue("max-wait"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void testWriteXML() throws IOException {
        String str = "<wait id=\"wait1\" start=\"1\" max-wait=\"2\"/>";
        WaitBehaviour behIn = new WaitBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        WaitBehaviour behOut = new WaitBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"wait1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((double)2.0, (double)behOut.getFloatParameterValue("max-wait"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

