/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.core.AbstractBehaviourTest;
import saiba.bml.core.Behaviour;
import saiba.bml.core.Pose;
import saiba.bml.core.PostureShiftBehaviour;

public class TestPostureShiftBehaviour
extends AbstractBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    protected Behaviour createBehaviour(String bmlId, String extraAttributeString) throws IOException {
        String str = "<postureShift id=\"posture1\" " + extraAttributeString + ">" + "<stance type=\"STANDING\"/><pose lexeme=\"LEANING_FORWARD\" " + "part=\"WHOLE_BODY\"/></postureShift>";
        return new PostureShiftBehaviour("bml1", new XMLTokenizer(str));
    }

    protected Behaviour parseBehaviour(String bmlId, String bmlString) throws IOException {
        return new PostureShiftBehaviour("bml1", new XMLTokenizer(bmlString));
    }

    @Test
    public void testReadXML() throws IOException {
        String str = "<postureShift start=\"1\" id=\"posture1\"><stance type=\"STANDING\"/><pose lexeme=\"LEANING_FORWARD\" part=\"WHOLE_BODY\"/></postureShift>";
        PostureShiftBehaviour beh = new PostureShiftBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"posture1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"STANDING", (Object)beh.getStringParameterValue("stance"));
        Pose p = beh.getPoseParts().get(0);
        Assert.assertEquals((Object)"LEANING_FORWARD", (Object)p.getLexeme());
        Assert.assertEquals((Object)"WHOLE_BODY", (Object)p.getPart());
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void testWriteXML() throws IOException {
        String str = "<postureShift start=\"1\" id=\"posture1\"><stance type=\"STANDING\"/><pose lexeme=\"LEANING_FORWARD\" part=\"WHOLE_BODY\"/></postureShift>";
        PostureShiftBehaviour behIn = new PostureShiftBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        PostureShiftBehaviour behOut = new PostureShiftBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"posture1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"STANDING", (Object)behOut.getStringParameterValue("stance"));
        Pose p = behOut.getPoseParts().get(0);
        Assert.assertEquals((Object)"LEANING_FORWARD", (Object)p.getLexeme());
        Assert.assertEquals((Object)"WHOLE_BODY", (Object)p.getPart());
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

