/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLFormatting;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import saiba.bml.core.BMLElement;
import saiba.bml.core.Sync;
import saiba.bml.parser.BMLParser;
import saiba.bml.parser.InvalidSyncRefException;
import saiba.bml.parser.SyncRef;

public class Synchronize
extends BMLElement {
    private ArrayList<Sync> syncs;
    private SyncRef ref;
    public final String bmlId;
    private static final String XMLTAG = "synchronize";

    public Synchronize(String bmlId) {
        this.bmlId = bmlId;
        this.syncs = new ArrayList();
        this.ref = null;
    }

    @Override
    public String getBmlId() {
        return this.bmlId;
    }

    public Synchronize(String bmlId, XMLTokenizer tokenizer) throws IOException {
        this(bmlId);
        this.readXML(tokenizer);
    }

    public ArrayList<Sync> getSyncs() {
        return this.syncs;
    }

    public SyncRef getRef() {
        return this.ref;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String r = this.getRequiredAttribute("ref", attrMap, tokenizer);
        try {
            this.ref = new SyncRef(this.bmlId, r);
        }
        catch (InvalidSyncRefException e) {
            throw new XMLScanException("Invalid sync ref");
        }
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Sync.xmlTag())) {
                this.syncs.add(new Sync(this.bmlId, tokenizer));
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Synchronize.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.syncs);
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        Synchronize.appendAttribute((StringBuilder)buf, (String)"ref", (String)this.ref.toString());
        return buf;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    public void constructConstraints(BMLParser scheduler) {
        scheduler.constructConstraints(this);
    }
}

