/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.core.AbstractBehaviourTest;
import saiba.bml.core.Behaviour;
import saiba.bml.core.SpeechBehaviour;

public class SpeechBehaviourTest
extends AbstractBehaviourTest {
    protected Behaviour createBehaviour(String bmlId, String extraAttributeString) throws IOException {
        String str = "<speech id=\"speech1\" " + extraAttributeString + "><text>Hello <sync id=\"s1\"/> world</text></speech>";
        return new SpeechBehaviour("bml1", new XMLTokenizer(str));
    }

    protected Behaviour parseBehaviour(String bmlId, String bmlString) throws IOException {
        return new SpeechBehaviour("bml1", new XMLTokenizer(bmlString));
    }

    @Test
    public void testReadXML() throws IOException {
        String str = "<speech id=\"speech1\"><text>Hello <sync id=\"s1\"/> world</text></speech>";
        SpeechBehaviour beh = new SpeechBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"speech1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"s1", (Object)beh.getSyncPoints().get(2).getName());
    }

    @Test
    public void testWriteXML() throws IOException {
        String str = "<speech id=\"speech1\"><text>Hello <sync id=\"s1\"/> world</text></speech>";
        SpeechBehaviour behIn = new SpeechBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        SpeechBehaviour behOut = new SpeechBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"speech1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"s1", (Object)behOut.getSyncPoints().get(2).getName());
    }
}

