/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import saiba.bml.core.RequiredBlock;

public class RequiredTest {
    private RequiredBlock reqBlock = new RequiredBlock("bml1");

    @Test
    public void testEmptyRequired() {
        this.reqBlock.readXML("<required/>");
        MatcherAssert.assertThat(this.reqBlock.behaviours, (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.reqBlock.constraintBlocks, (Matcher)Matchers.empty());
    }

    @Test
    public void testRequiredBehaviors() {
        this.reqBlock.readXML("<required><gaze id=\"gaze1\" type=\"AT\" target=\"person1\"/><gaze id=\"gaze2\" type=\"AT\" target=\"person1\"/></required>");
        MatcherAssert.assertThat(this.reqBlock.behaviours, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat(this.reqBlock.constraintBlocks, (Matcher)Matchers.empty());
    }

    @Test
    public void testRequiredConstraints() {
        this.reqBlock.readXML("<required><constraint id=\"c1\"/><constraint id=\"c2\"><synchronize ref=\"beh3:start\"><sync ref=\"beh1:start\"/><sync ref=\"beh2:start\"/></synchronize></constraint></required>");
        MatcherAssert.assertThat(this.reqBlock.behaviours, (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.reqBlock.constraintBlocks, (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void testRequiredConstraintsAndBehaviors() {
        this.reqBlock.readXML("<required><constraint id=\"c1\"/><gaze id=\"gaze1\" type=\"AT\" target=\"person1\"/><constraint id=\"c2\"><synchronize ref=\"beh3:start\"><sync ref=\"beh1:start\"/><sync ref=\"beh2:start\"/></synchronize></constraint><gaze id=\"gaze1\" type=\"AT\" target=\"person1\"/></required>");
        MatcherAssert.assertThat(this.reqBlock.constraintBlocks, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat(this.reqBlock.behaviours, (Matcher)IsCollectionWithSize.hasSize((int)2));
    }
}

