/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import saiba.bml.core.Behaviour;
import saiba.bml.core.Pose;
import saiba.bml.core.Stance;
import saiba.bml.parser.SyncPoint;

public class PostureBehaviour
extends Behaviour {
    private Stance stance;
    private List<Pose> poseParts = new ArrayList<Pose>();
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"ready", (Object)"relax", (Object)"end");
    private static final String XMLTAG = "posture";

    public List<Pose> getPoseParts() {
        return this.poseParts;
    }

    @Override
    public void addDefaultSyncPoints() {
        for (String s : PostureBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("stance") && this.stance != null) {
            return this.stance.getStanceType();
        }
        return super.getStringParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) {
        return super.getFloatParameterValue(name);
    }

    @Override
    public boolean specifiesParameter(String name) {
        if (name.equals("stance") && this.stance != null) {
            return true;
        }
        return super.specifiesParameter(name);
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("stance") && this.stance != null) {
            return ((Object)((Object)this.stance)).equals(value);
        }
        return super.satisfiesConstraint(name, value);
    }

    @Override
    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        if (this.stance != null) {
            this.stance.appendXML(buf, fmt);
        }
        for (Pose p : this.poseParts) {
            p.appendXML(buf, fmt);
        }
        return super.appendContent(buf, fmt);
    }

    @Override
    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (!tokenizer.atETag()) {
            if (tokenizer.atSTag(Pose.xmlTag())) {
                Pose p = new Pose();
                p.readXML(tokenizer);
                this.poseParts.add(p);
            } else if (tokenizer.atSTag(Stance.xmlTag())) {
                this.stance = new Stance();
                this.stance.readXML(tokenizer);
            } else {
                super.decodeContent(tokenizer);
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    public PostureBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    @Override
    public boolean hasContent() {
        return true;
    }
}

