/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.core.AbstractBehaviourTest;
import saiba.bml.core.Behaviour;
import saiba.bml.core.PointingBehaviour;

public class PointingBehaviourTest
extends AbstractBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    protected Behaviour createBehaviour(String bmlId, String extraAttributeString) throws IOException {
        String str = "<pointing id=\"point1\" target=\"bluebox\" " + extraAttributeString + " />";
        return new PointingBehaviour(bmlId, new XMLTokenizer(str));
    }

    protected Behaviour parseBehaviour(String bmlId, String bmlString) throws IOException {
        return new PointingBehaviour(bmlId, new XMLTokenizer(bmlString));
    }

    @Test
    public void testReadXML() throws IOException {
        String str = "<pointing id=\"point1\" target=\"bluebox\" mode=\"RIGHT_HAND\" start=\"1\" />";
        PointingBehaviour beh = new PointingBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"point1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)beh.getStringParameterValue("target"));
        Assert.assertEquals((Object)"RIGHT_HAND", (Object)beh.getStringParameterValue("mode"));
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void testWriteXML() throws IOException {
        String str = "<pointing id=\"point1\" target=\"bluebox\" mode=\"RIGHT_HAND\" start=\"1\" />";
        PointingBehaviour behIn = new PointingBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        PointingBehaviour behOut = new PointingBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"point1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)behOut.getStringParameterValue("target"));
        Assert.assertEquals((Object)"RIGHT_HAND", (Object)behOut.getStringParameterValue("mode"));
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

