/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.core.AbstractBehaviourTest;
import saiba.bml.core.Behaviour;
import saiba.bml.core.LocomotionBehaviour;

public class LocomotionBehaviourTest
extends AbstractBehaviourTest {
    protected Behaviour createBehaviour(String bmlId, String extraAttributeString) throws IOException {
        String str = "<locomotion id=\"loc1\" target=\"bluebox\" " + extraAttributeString + "/>";
        return new LocomotionBehaviour("bml1", new XMLTokenizer(str));
    }

    protected Behaviour parseBehaviour(String bmlId, String bmlString) throws IOException {
        return new LocomotionBehaviour("bml1", new XMLTokenizer(bmlString));
    }

    @Test
    public void testReadLocomotion() throws IOException {
        String str = "<locomotion id=\"loc1\" target=\"bluebox\" start=\"1\" manner=\"RUN\"/>";
        LocomotionBehaviour beh = new LocomotionBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"loc1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)beh.getStringParameterValue("target"));
        Assert.assertEquals((Object)"RUN", (Object)beh.getStringParameterValue("manner"));
    }

    @Test
    public void writeReadXML() throws IOException {
        String str = "<locomotion id=\"loc1\" target=\"bluebox\" start=\"1\" manner=\"RUN\"/>";
        LocomotionBehaviour behIn = new LocomotionBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        LocomotionBehaviour behOut = new LocomotionBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"loc1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)behOut.getStringParameterValue("target"));
        Assert.assertEquals((Object)"RUN", (Object)behOut.getStringParameterValue("manner"));
    }
}

