/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.core.AbstractBehaviourTest;
import saiba.bml.core.Behaviour;
import saiba.bml.core.HeadDirectionShiftBehaviour;

public class HeadDirectionShiftBehaviourTest
extends AbstractBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    protected Behaviour createBehaviour(String bmlId, String extraAttributeString) throws IOException {
        String str = "<headDirectionShift id=\"head1\" target=\"bluebox\" " + extraAttributeString + "/>";
        return new HeadDirectionShiftBehaviour(bmlId, new XMLTokenizer(str));
    }

    protected Behaviour parseBehaviour(String bmlId, String bmlString) throws IOException {
        return new HeadDirectionShiftBehaviour(bmlId, new XMLTokenizer(bmlString));
    }

    @Test
    public void testReadXML() throws IOException {
        String str = "<headDirectionShift id=\"head1\" start=\"1\" target=\"bluebox\"/>";
        HeadDirectionShiftBehaviour beh = new HeadDirectionShiftBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"head1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)beh.getStringParameterValue("target"));
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void testWriteXML() throws IOException {
        String str = "<headDirectionShift id=\"head1\" start=\"1\" target=\"bluebox\"/>";
        HeadDirectionShiftBehaviour behIn = new HeadDirectionShiftBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        HeadDirectionShiftBehaviour behOut = new HeadDirectionShiftBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"head1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)behOut.getStringParameterValue("target"));
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

