/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.core.AbstractBehaviourTest;
import saiba.bml.core.Behaviour;
import saiba.bml.core.GestureBehaviour;

public class GestureBehaviourTest
extends AbstractBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    protected Behaviour createBehaviour(String bmlId, String extraAttributeString) throws IOException {
        String str = "<gesture id=\"g1\" lexeme=\"BEAT\" " + extraAttributeString + "/>";
        return new GestureBehaviour(bmlId, new XMLTokenizer(str));
    }

    protected Behaviour parseBehaviour(String bmlId, String bmlString) throws IOException {
        return new GestureBehaviour(bmlId, new XMLTokenizer(bmlString));
    }

    @Test
    public void testReadXML() throws IOException {
        String str = "<gesture start=\"1\" id=\"g1\" mode=\"LEFT_HAND\" lexeme=\"BEAT\"/>";
        GestureBehaviour beh = new GestureBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"g1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"LEFT_HAND", (Object)beh.getStringParameterValue("mode"));
        Assert.assertEquals((Object)"BEAT", (Object)beh.getStringParameterValue("lexeme"));
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void testWriteXML() throws IOException {
        String str = "<gesture start=\"1\" id=\"g1\" mode=\"LEFT_HAND\" lexeme=\"BEAT\"/>";
        GestureBehaviour behIn = new GestureBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        GestureBehaviour behOut = new GestureBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"g1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"LEFT_HAND", (Object)behOut.getStringParameterValue("mode"));
        Assert.assertEquals((Object)"BEAT", (Object)behOut.getStringParameterValue("lexeme"));
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

