/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.core.AbstractBehaviourTest;
import saiba.bml.core.Behaviour;
import saiba.bml.core.GazeShiftBehaviour;

public class GazeShiftBehaviourTest
extends AbstractBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    protected Behaviour createBehaviour(String bmlId, String extraAttributeString) throws IOException {
        String str = "<gazeShift id=\"gaze1\" target=\"bluebox\" influence=\"NECK\" " + extraAttributeString + "/>";
        return new GazeShiftBehaviour("bml1", new XMLTokenizer(str));
    }

    protected Behaviour parseBehaviour(String bmlId, String bmlString) throws IOException {
        return new GazeShiftBehaviour("bml1", new XMLTokenizer(bmlString));
    }

    @Test
    public void testReadXML() throws IOException {
        String str = "<gazeShift id=\"gaze1\" target=\"bluebox\" offsetAngle=\"10\" offsetDirection=\"RIGHT\" start=\"1\" influence=\"NECK\"/>";
        GazeShiftBehaviour beh = new GazeShiftBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"gaze1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)beh.getStringParameterValue("target"));
        Assert.assertEquals((Object)"NECK", (Object)beh.getStringParameterValue("influence"));
        Assert.assertEquals((Object)"RIGHT", (Object)beh.getStringParameterValue("offsetDirection"));
        Assert.assertEquals((double)10.0, (double)beh.getFloatParameterValue("offsetAngle"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void testWriteXML() throws IOException {
        String str = "<gazeShift id=\"gaze1\" target=\"bluebox\" offsetAngle=\"10\" offsetDirection=\"RIGHT\" start=\"1\" influence=\"NECK\"/>";
        GazeShiftBehaviour behIn = new GazeShiftBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        GazeShiftBehaviour behOut = new GazeShiftBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"gaze1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)behOut.getStringParameterValue("target"));
        Assert.assertEquals((Object)"NECK", (Object)behOut.getStringParameterValue("influence"));
        Assert.assertEquals((Object)"RIGHT", (Object)behOut.getStringParameterValue("offsetDirection"));
        Assert.assertEquals((double)10.0, (double)behOut.getFloatParameterValue("offsetAngle"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

