/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.core.AbstractBehaviourTest;
import saiba.bml.core.Behaviour;
import saiba.bml.core.FaceLexemeBehaviour;

public class FaceLexemeBehaviourTest
extends AbstractBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    protected Behaviour createBehaviour(String bmlId, String extraAttributeString) throws IOException {
        String str = "<faceLexeme amount=\"0.25\" lexeme=\"lex1\" id=\"beh1\"" + extraAttributeString + "/>";
        return new FaceLexemeBehaviour("bml1", new XMLTokenizer(str));
    }

    protected Behaviour parseBehaviour(String bmlId, String bmlString) throws IOException {
        return new FaceLexemeBehaviour("bml1", new XMLTokenizer(bmlString));
    }

    @Test
    public void testReadXML() throws IOException {
        String str = "<faceLexeme id=\"face1\" amount=\"0.25\" start=\"1\" lexeme=\"lex1\"/>";
        FaceLexemeBehaviour beh = new FaceLexemeBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"face1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"lex1", (Object)beh.getStringParameterValue("lexeme"));
        Assert.assertEquals((double)0.25, (double)beh.getFloatParameterValue("amount"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void writeReadXML() throws IOException {
        String str = "<faceLexeme id=\"face1\" type=\"LEXICALIZED\" amount=\"0.25\" start=\"1\" lexeme=\"lex1\"/>";
        FaceLexemeBehaviour behIn = new FaceLexemeBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        FaceLexemeBehaviour behOut = new FaceLexemeBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"face1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"lex1", (Object)behOut.getStringParameterValue("lexeme"));
        Assert.assertEquals((double)0.25, (double)behOut.getFloatParameterValue("amount"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

