/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml.core;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import saiba.bml.BMLInfo;
import saiba.bml.core.Behaviour;

public abstract class AbstractBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    protected abstract Behaviour createBehaviour(String var1, String var2) throws IOException;

    protected abstract Behaviour parseBehaviour(String var1, String var2) throws IOException;

    @Test
    public void testCustomFloatAttribute() throws IOException {
        BMLInfo.addCustomFloatAttribute(((Object)((Object)this.createBehaviour("bml1", ""))).getClass(), "customfaceattributes", "attr2");
        Behaviour beh = this.createBehaviour("bml1", "xmlns:custom=\"customfaceattributes\" custom:attr2=\"10\"");
        Assert.assertEquals((double)10.0, (double)beh.getFloatParameterValue("customfaceattributes:attr2"), (double)1.0E-4);
        Assert.assertTrue((boolean)beh.specifiesParameter("customfaceattributes:attr2"));
    }

    @Test
    public void testCustomStringAttribute() throws IOException {
        BMLInfo.addCustomStringAttribute(((Object)((Object)this.createBehaviour("bml1", ""))).getClass(), "customfaceattributes", "attr1");
        Behaviour beh = this.createBehaviour("bml1", "xmlns:custom=\"customfaceattributes\" custom:attr1=\"blah\"");
        Assert.assertEquals((Object)"blah", (Object)beh.getStringParameterValue("customfaceattributes:attr1"));
        Assert.assertTrue((boolean)beh.specifiesParameter("customfaceattributes:attr1"));
        Assert.assertTrue((boolean)beh.satisfiesConstraint("customfaceattributes:attr1", "blah"));
    }

    @Test
    public void testWriteCustomFloatAttribute() throws IOException {
        BMLInfo.addCustomFloatAttribute(((Object)((Object)this.createBehaviour("bml1", ""))).getClass(), "customfaceattributes", "attr2");
        Behaviour behIn = this.createBehaviour("bml1", "xmlns:custom=\"customfaceattributes\" custom:attr2=\"10\"");
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        Behaviour behOut = this.parseBehaviour("bml1", buf.toString());
        Assert.assertEquals((double)10.0, (double)behOut.getFloatParameterValue("customfaceattributes:attr2"), (double)1.0E-4);
        Assert.assertTrue((boolean)behOut.specifiesParameter("customfaceattributes:attr2"));
    }

    @Test
    public void testWriteCustomStringAttribute() throws IOException {
        BMLInfo.addCustomStringAttribute(((Object)((Object)this.createBehaviour("bml1", ""))).getClass(), "customfaceattributes", "attr1");
        Behaviour behIn = this.createBehaviour("bml1", "xmlns:custom=\"customfaceattributes\" custom:attr1=\"blah\"");
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        Behaviour behOut = this.parseBehaviour("bml1", buf.toString());
        Assert.assertEquals((Object)"blah", (Object)behOut.getStringParameterValue("customfaceattributes:attr1"));
        Assert.assertTrue((boolean)behOut.specifiesParameter("customfaceattributes:attr1"));
    }
}

