/*
 * Decompiled with CFR 0.152.
 */
package saiba.bml;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum BMLGestureSync {
    START("start"),
    READY("ready"),
    STROKE_START("strokeStart"),
    STROKE("stroke"),
    STROKE_END("strokeEnd"),
    RELAX("relax"),
    END("end");

    private String id;
    private static Map<String, BMLGestureSync> idToSync;

    public boolean isBefore(BMLGestureSync s) {
        return this.ordinal() < s.ordinal();
    }

    public boolean isAfter(BMLGestureSync s) {
        return this.ordinal() > s.ordinal();
    }

    public static boolean isBMLSync(String id) {
        return idToSync.get(id) != null;
    }

    private BMLGestureSync(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static BMLGestureSync get(String id) {
        return idToSync.get(id);
    }

    public String toString() {
        return this.id;
    }

    static {
        idToSync = new HashMap<String, BMLGestureSync>();
        for (BMLGestureSync bs : EnumSet.allOf(BMLGestureSync.class)) {
            idToSync.put(bs.getId(), bs);
        }
    }
}

