/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.parser;

import com.google.common.base.Objects;
import hmi.bml.parser.InvalidSyncRefException;
import hmi.util.StringUtil;

public class SyncRef {
    public String bbId;
    public String sourceId;
    public String syncId;
    public int iteration = -1;
    public double offset = 0.0;

    private String parseOffset(String syncRef) throws InvalidSyncRefException {
        String[] split;
        String offsetStr = "";
        int plusMin = 0;
        if (StringUtil.isNumeric((String)syncRef.trim())) {
            offsetStr = syncRef.trim();
            this.offset = Double.parseDouble(offsetStr);
        }
        if (offsetStr.length() == 0 && (split = syncRef.split("-")).length > 1) {
            offsetStr = split[split.length - 1];
            if (StringUtil.isNumeric((String)offsetStr.trim())) {
                this.offset = -Double.parseDouble(offsetStr.trim());
                plusMin = 1;
            } else {
                throw new InvalidSyncRefException("Invalid SyncRef: " + syncRef + ", syncref contains - without offset");
            }
        }
        if (offsetStr.length() == 0 && (split = syncRef.split("\\+")).length > 1) {
            offsetStr = split[split.length - 1];
            if (StringUtil.isNumeric((String)offsetStr.trim())) {
                this.offset = Double.parseDouble(offsetStr.trim());
                plusMin = 1;
            } else {
                throw new InvalidSyncRefException("Invalid SyncRef: " + syncRef + ", syncref contains + without offset");
            }
        }
        return syncRef.substring(0, syncRef.length() - (offsetStr.length() + plusMin));
    }

    public SyncRef(String defaultBMLId, String syncRef) throws InvalidSyncRefException {
        this.bbId = defaultBMLId;
        String remainder = this.parseOffset(syncRef);
        if (remainder.length() == 0) {
            this.sourceId = "bml";
            this.syncId = "start";
            return;
        }
        if (remainder.startsWith(":")) {
            throw new InvalidSyncRefException("Invalid SyncRef: " + syncRef);
        }
        if (remainder.endsWith(":")) {
            throw new InvalidSyncRefException("Invalid SyncRef: " + syncRef);
        }
        String[] split = remainder.split(":");
        if (split.length < 2) {
            throw new InvalidSyncRefException("Invalid SyncRef: " + syncRef);
        }
        if (split.length > 4) {
            throw new InvalidSyncRefException("Invalid SyncRef: " + syncRef);
        }
        if (split.length >= 3) {
            if (StringUtil.isPostiveInteger((String)split[split.length - 1].trim())) {
                this.iteration = Integer.parseInt(split[split.length - 1].trim());
            } else if (split.length > 3) {
                throw new InvalidSyncRefException("Invalid SyncRef: " + syncRef + " , iteration number must be a positive integer.");
            }
        }
        if (split.length == 3 && this.iteration == -1 || split.length > 3) {
            this.bbId = split[0].trim();
            this.sourceId = split[1].trim();
            this.syncId = split[2].trim();
        } else {
            this.sourceId = split[0].trim();
            this.syncId = split[1].trim();
        }
        if (this.iteration != -1 && !this.syncId.equals("stroke")) {
            throw new InvalidSyncRefException("Invalid SyncRef: " + syncRef + " , iteration number must be a positive integer.");
        }
    }

    public boolean equals(Object s) {
        if (s instanceof SyncRef) {
            SyncRef sr = (SyncRef)s;
            return sr.offset == this.offset && sr.sourceId.equals(this.sourceId) && sr.syncId.equals(this.syncId) && sr.iteration == this.iteration && sr.bbId.equals(this.bbId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.offset, this.sourceId, this.syncId, this.iteration, this.bbId});
    }

    private String getSourceAndSyncString() {
        String s = this.sourceId + ":" + this.syncId;
        if (this.iteration != -1) {
            s = s + ":" + this.iteration;
        }
        if (this.offset != 0.0) {
            if (this.offset > 0.0) {
                s = s + '+';
            }
            s = s + this.offset;
        }
        return s;
    }

    public String toString(String bmlId) {
        if (this.bbId.equals(bmlId) && this.sourceId.equals("bml") && this.syncId.equals("start")) {
            return "" + this.offset;
        }
        String s = "";
        if (!this.bbId.equals(bmlId)) {
            s = this.bbId + ":";
        }
        s = s + this.getSourceAndSyncString();
        return s;
    }

    public String toString() {
        return this.bbId + ":" + this.getSourceAndSyncString();
    }
}

