/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.parser;

import hmi.bml.core.Behaviour;
import hmi.bml.parser.BMLParser;
import hmi.bml.parser.Constraint;
import hmi.bml.parser.InvalidSyncRefException;
import hmi.bml.parser.SyncRef;
import hmi.xml.XMLScanException;

public class SyncPoint {
    private final String name;
    private String behaviourId = null;
    private String bmlId;
    private int iteration = -1;
    public double offset;
    private SyncRef ref;
    private Constraint constraint;

    public void setBehaviourId(String behaviourId) {
        this.behaviourId = behaviourId;
    }

    public void setBMLId(String bmlId) {
        this.bmlId = bmlId;
    }

    public String getBehaviourId() {
        return this.behaviourId;
    }

    public String getBmlId() {
        return this.bmlId;
    }

    public SyncPoint(String bmlId, String behaviorId, String name) {
        this.bmlId = bmlId;
        this.behaviourId = behaviorId;
        this.name = name;
    }

    public SyncPoint(SyncPoint s) {
        this.name = s.name;
        this.bmlId = s.bmlId;
        this.behaviourId = s.behaviourId;
        this.iteration = s.iteration;
        this.offset = s.offset;
        this.ref = s.ref;
        this.constraint = s.constraint;
    }

    public SyncPoint(String bmlId, String behaviorId, String name, int iteration) {
        this(bmlId, behaviorId, name);
        this.iteration = iteration;
    }

    public boolean equalsPoint(SyncPoint p) {
        if (p.behaviourId == null && this.behaviourId == null) {
            String[] str = p.name.split(":");
            if (str.length != 2 || str[0].equals("bml")) {
                return false;
            }
        } else {
            if (p.behaviourId == null) {
                return false;
            }
            if (this.behaviourId == null) {
                return false;
            }
            if (!p.behaviourId.equals(this.behaviourId)) {
                return false;
            }
        }
        return p.name.equals(this.name) && p.iteration == this.iteration;
    }

    public SyncPoint(String bmlId, SyncRef ref) {
        this.bmlId = bmlId;
        this.behaviourId = null;
        this.name = null;
        this.ref = ref;
    }

    public int getIteration() {
        return this.iteration;
    }

    public String getName() {
        return this.name;
    }

    public void setRefString(String ref) throws InvalidSyncRefException {
        this.ref = new SyncRef(this.bmlId, ref);
    }

    public SyncRef getRef() {
        return this.ref;
    }

    public String getRefString() {
        if (this.ref != null) {
            return this.ref.toString(this.bmlId);
        }
        return "";
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append(this.bmlId + ":" + this.behaviourId);
        retval.append(":" + this.name);
        if (this.iteration != -1) {
            retval.append(":" + this.iteration);
        }
        if (this.offset != 0.0) {
            retval.append(this.offset > 0.0 ? Character.valueOf('+') : "");
            retval.append(this.offset);
        }
        return retval.toString();
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public boolean inConstraint() {
        return this.constraint != null;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public SyncPoint getForeignSyncPoint(BMLParser scheduler) {
        Behaviour behaviour = null;
        if (!this.ref.sourceId.equals("bml")) {
            behaviour = (Behaviour)scheduler.getBMLElementById(this.ref.bbId + ':' + this.ref.sourceId);
        }
        if (behaviour == null) {
            SyncPoint s;
            if (this.ref.syncId.equals("")) {
                s = new SyncPoint(this.ref.bbId, null, "start");
                s.offset = this.ref.offset;
            } else {
                if (this.ref.bbId.equals("anticipators") || this.ref.sourceId.equals("bml")) {
                    s = new SyncPoint(this.ref.bbId, null, this.ref.sourceId + ":" + this.ref.syncId);
                } else {
                    if (this.ref.bbId.equals(this.bmlId)) {
                        throw new XMLScanException("Reference " + this.ref + " to behaviour " + this.ref.sourceId + " in the same block not found.");
                    }
                    s = new SyncPoint(this.ref.bbId, this.ref.sourceId, this.ref.syncId);
                }
                s.offset = this.ref.offset;
            }
            return s;
        }
        for (SyncPoint syncPoint : behaviour.getSyncPoints()) {
            if (!syncPoint.name.equals(this.ref.syncId) || syncPoint.iteration != this.ref.iteration && this.ref.iteration != -1 || syncPoint.offset != this.ref.offset) continue;
            return syncPoint;
        }
        SyncPoint s = new SyncPoint(behaviour.getBmlId(), behaviour.id, this.ref.syncId);
        s.offset = this.ref.offset;
        behaviour.addSyncPoint(s);
        return s;
    }

    public double getOffset() {
        return this.offset;
    }
}

