/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.parser;

import hmi.bml.core.BMLBehaviorAttributeExtension;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.parser.BMLParser;
import hmi.bml.parser.Constraint;
import hmi.bml.parser.ExpectedConstraint;
import hmi.bml.parser.ExpectedSync;
import hmi.bml.parser.ParserTestUtil;
import hmi.util.Resources;
import hmi.xml.XMLScanException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParserTest {
    private Resources res;
    private BMLParser parser;
    private List<ExpectedConstraint> expectedConstraints;
    private static final int PARSE_TIMEOUT = 300;

    @Before
    public void setup() {
        this.res = new Resources("bmltest");
        this.expectedConstraints = new ArrayList();
        this.parser = new BMLParser();
    }

    private void readXML(String file) throws IOException {
        this.parser.clear();
        BehaviourBlock block = new BehaviourBlock(new BMLBehaviorAttributeExtension[0]);
        block.readXML(this.res.getReader(file));
        this.parser.addBehaviourBlock(block);
    }

    @Test(timeout=300L)
    public void constraintSpeechRelTest() throws IOException {
        this.readXML("testspeechrel_offsets.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 4.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod2", "start", 2.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "speech2", "start", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "end", 5.0));
        this.expectedConstraints.add(expected2);
        ExpectedConstraint expected3 = new ExpectedConstraint();
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "nod2", "end", 0.0));
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "speech2", "end", 3.0));
        this.expectedConstraints.add(expected3);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void testWaitDoubleSync() throws IOException {
        this.readXML("waitdoublesync.xml");
        ArrayList<ExpectedConstraint> expectedConstraints = new ArrayList<ExpectedConstraint>();
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "w1", "start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "start", 0.0));
        expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "w1", "end", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "end", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "speech2", "start", 0.0));
        expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints(expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintNodOffsetTest() throws IOException {
        this.readXML("testnod_offset.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 1.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod2", "start", -1.0));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintTimeShiftTest() throws IOException {
        this.readXML("testtimeshift.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "end", 0.0));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintNodInvalidTimeTest() throws IOException {
        this.readXML("testnod_invalidtime.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 2.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "end", 0.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintNodAbsoluteTimeTest() throws IOException {
        this.readXML("testnod_absolute.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 2.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "end", 0.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintNod2xAbsoluteTimeTest() throws IOException {
        this.readXML("testnod2x_absolute.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 1.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 3.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "nod2", "start", 0.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintSpeechEndTimedTest() throws IOException {
        this.readXML("testspeech_endtimed.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 5.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "end", 0.0));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintNodTest() throws IOException {
        this.readXML("testnod.xml");
        ArrayList<Constraint> constraints = this.parser.getConstraints();
        Assert.assertEquals((long)0L, (long)constraints.size());
    }

    @Test(timeout=300L)
    public void testSpeech2linked() throws IOException {
        this.readXML("testspeech_2linked.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "end", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech2", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintNodUnkownAttributeTest() throws IOException {
        this.readXML("testnod_unknownattributes.xml");
        ArrayList<Constraint> constraints = this.parser.getConstraints();
        Assert.assertEquals((long)0L, (long)constraints.size());
    }

    @Test(timeout=300L)
    public void constraintOffsetTest() throws IOException {
        this.readXML("testoffset.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "h1", "start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "g1", "end", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 3.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "g2", "start", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "g2", "end", -1.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "g1", "start", -1.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintOffset2Test() throws IOException {
        this.readXML("testoffset2.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "h1", "start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "g1", "end", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 3.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "g2", "start", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "g2", "end", -2.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "g1", "start", -1.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintOffset3Test() throws IOException {
        this.readXML("testoffset3.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 3.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "g2", "start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "g2", "end", -2.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "g1", "start", -1.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "gaze1", "start", 2.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "h1", "start", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "g1", "end", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "gaze1", "end", -3.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintOffsetChainTest() throws IOException {
        this.readXML("testoffsetchain.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 4.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "h1", "start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "h2", "start", -2.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "h3", "start", -4.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "h4", "start", -6.0));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintOffsetChainReversedTest() throws IOException {
        this.readXML("testoffsetchainreversed.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 10.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "h1", "start", 6.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "h2", "start", 4.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "h3", "start", 2.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "h4", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintSpeech3xTest() throws IOException {
        this.readXML("testspeech3x.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 4.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech10", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "speech11", "start", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "speech10", "end", 4.0));
        this.expectedConstraints.add(expected2);
        ExpectedConstraint expected3 = new ExpectedConstraint();
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "speech12", "start", 0.0));
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "speech11", "end", 4.0));
        this.expectedConstraints.add(expected3);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintEmptyTest() throws IOException {
        this.readXML("empty.xml");
        ArrayList<Constraint> constraints = this.parser.getConstraints();
        Assert.assertEquals((long)0L, (long)constraints.size());
    }

    @Test(timeout=300L)
    public void speechinvalidTimeSyncTest() throws IOException {
        this.readXML("testspeech_invalidtimesync.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 0.01));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "s1", 0.0));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintSpeechInvalidTimeSync2Test() throws IOException {
        this.readXML("testspeech_invalidtimesync2.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 10.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "s1", 0.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintSpeechAndNodSyncTimedTest() throws IOException {
        this.readXML("testspeechandnod_synctimed.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 10.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "s1", 0.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintSpeechSyncTimedTest() throws IOException {
        this.readXML("testspeech_synctimed.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 10.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "s1", 0.0));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintSpeechSyncTimedTest2x() throws IOException {
        this.readXML("testspeech_synctimed2x.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 10.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "s1", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech2", "s1", -10.0));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintSpeechSyncAtStartTest() throws IOException {
        this.readXML("testspeech_syncatstart.xml");
        Assert.assertEquals((long)0L, (long)this.parser.getConstraints().size());
    }

    @Test(timeout=300L)
    public void constraintSpeechSyncAtStartAndToBeatTest() throws IOException {
        this.readXML("testspeech_syncatstartandtobeat.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "welkom", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "g1", "start", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "g1", "end", -2.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "welkom", "deicticheart1", 0.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L, expected=XMLScanException.class)
    public void constraintSpeechUnknownBehaviorTest() throws IOException {
        this.readXML("testspeech_unknownbehavior.xml");
    }

    @Test(timeout=300L)
    public void constraintSpeechUnknownSyncTest() throws IOException {
        this.readXML("testspeech_unknownsync.xml");
        ExpectedConstraint expected = new ExpectedConstraint();
        expected.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        expected.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "unknown", 0.0));
        this.expectedConstraints.add(expected);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintAbsTest() throws IOException {
        this.readXML("testabs.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 1.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 1.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "g1", "start", 0.0));
        this.expectedConstraints.add(expected2);
        ExpectedConstraint expected3 = new ExpectedConstraint();
        expected3.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 1.0));
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "start", 0.0));
        this.expectedConstraints.add(expected3);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintGazeReadyTimedTest() throws IOException {
        this.readXML("testgazereadytimed.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 1.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "gaze1", "ready", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 10.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "gaze1", "end", 0.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void constraintGazeOffsetTest() throws IOException {
        this.readXML("testoffsetgaze.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "gaze1", "ready", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 2.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "gaze1", "start", 0.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void beatreadytimed() throws IOException {
        this.readXML("testbeatreadytimed.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 1.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "beat1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 2.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "beat1", "ready", 0.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void testnods() throws IOException {
        this.readXML("testnods.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 1.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "tilt1", "start", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "end", 1.0));
        this.expectedConstraints.add(expected2);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void testSpeechNodTimedToSync() throws IOException {
        this.readXML("testspeech_nodtimedtosync.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 6.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "syncstart1", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        this.expectedConstraints.add(expected2);
        ExpectedConstraint expected3 = new ExpectedConstraint();
        expected3.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 9.0));
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "end", 0.0));
        this.expectedConstraints.add(expected3);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void testSpeechNodTimedToSyncOffset() throws IOException {
        this.readXML("testspeech_nodtimedtosyncoffset.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 6.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "speech1", "syncstart1", 1.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        this.expectedConstraints.add(expected2);
        ExpectedConstraint expected3 = new ExpectedConstraint();
        expected3.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 9.0));
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "end", 0.0));
        this.expectedConstraints.add(expected3);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void testSpeechNodTimedToSyncCapitalization() throws IOException {
        this.readXML("testspeech_nodtimedtosync_capitalization.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("BMLWithCapitalizedStuff", null, "bml:start", 6.0));
        expected1.expectedSyncs.add(new ExpectedSync("BMLWithCapitalizedStuff", "speech1WithCapitalizedStuff", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("BMLWithCapitalizedStuff", "speech1WithCapitalizedStuff", "syncStart_1", 0.0));
        expected2.expectedSyncs.add(new ExpectedSync("BMLWithCapitalizedStuff", "nod1WithCapitalizedStuff", "start", 0.0));
        this.expectedConstraints.add(expected2);
        ExpectedConstraint expected3 = new ExpectedConstraint();
        expected3.expectedSyncs.add(new ExpectedSync("BMLWithCapitalizedStuff", null, "bml:start", 9.0));
        expected3.expectedSyncs.add(new ExpectedSync("BMLWithCapitalizedStuff", "nod1WithCapitalizedStuff", "end", 0.0));
        this.expectedConstraints.add(expected3);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void testbeatandnod() throws IOException {
        this.readXML("testbeatandnod.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 3.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "beat1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 7.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "beat1", "end", 0.0));
        this.expectedConstraints.add(expected2);
        ExpectedConstraint expected3 = new ExpectedConstraint();
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "beat1", "strokeEnd", 0.0));
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        this.expectedConstraints.add(expected3);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void testnodandbeat() throws IOException {
        this.readXML("testnodandbeat.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 3.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "start", 0.0));
        this.expectedConstraints.add(expected1);
        ExpectedConstraint expected2 = new ExpectedConstraint();
        expected2.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 5.0));
        expected2.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "end", 0.0));
        this.expectedConstraints.add(expected2);
        ExpectedConstraint expected3 = new ExpectedConstraint();
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "nod1", "stroke", 0.0));
        expected3.expectedSyncs.add(new ExpectedSync("bml1", "beat1", "start", 0.0));
        this.expectedConstraints.add(expected3);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L)
    public void testspeechgestures() throws IOException {
        this.readXML("testspeechgestures.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "g1", "start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "g1", "end", -2.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "welkom", "deicticheart1", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "transleft", "end", -1.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "transleft", "start", 1.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "relaxleft", "end", -4.8));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "relaxleft", "start", -2.5));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }

    @Test(timeout=300L, expected=XMLScanException.class)
    public void testinvalidXML() throws IOException {
        this.readXML("testinvalidxml.xml");
    }

    @Test(timeout=300L, expected=XMLScanException.class)
    public void testinvalidXML2() throws IOException {
        this.readXML("testinvalidxml2.xml");
    }

    @Test(timeout=300L)
    public void headselftimed() throws IOException {
        this.readXML("testhead_selftimed.xml");
        ExpectedConstraint expected1 = new ExpectedConstraint();
        expected1.expectedSyncs.add(new ExpectedSync("bml1", null, "bml:start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "shake1", "start", 0.0));
        expected1.expectedSyncs.add(new ExpectedSync("bml1", "shake1", "end", -1.0));
        this.expectedConstraints.add(expected1);
        ParserTestUtil.assertEqualConstraints((List)this.expectedConstraints, this.parser.getConstraints());
    }
}

