/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.parser;

import hmi.bml.core.BMLBehaviorAttributeExtension;
import hmi.bml.core.Behaviour;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.parser.BMLParser;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BMLParserBlockPropertiesTest {
    private BMLParser parser = new BMLParser();

    @Before
    public void setup() {
    }

    @Test
    public void testDirectLink() {
        BehaviourBlock bb = new BehaviourBlock(new BMLBehaviorAttributeExtension[0]);
        bb.readXML("<bml id=\"bml1\"><gesture id=\"g1\" start=\"g2:start\" type=\"BEAT\"/><gesture id=\"g2\" type=\"BEAT\"/></bml>");
        this.parser.addBehaviourBlock(bb);
        Assert.assertTrue((boolean)this.parser.directLink("bml1", "g1", "bml1", "g2"));
    }

    @Test
    public void testNoDirectLink() {
        BehaviourBlock bb = new BehaviourBlock(new BMLBehaviorAttributeExtension[0]);
        bb.readXML("<bml id=\"bml1\"><gesture id=\"g1\" type=\"BEAT\"/><gesture id=\"g2\" type=\"BEAT\"/></bml>");
        this.parser.addBehaviourBlock(bb);
        Assert.assertFalse((boolean)this.parser.directLink("bml1", "g1", "bml1", "g2"));
    }

    @Test
    public void testDirectGrounded() {
        BehaviourBlock bb = new BehaviourBlock(new BMLBehaviorAttributeExtension[0]);
        bb.readXML("<bml id=\"bml1\"><gesture id=\"g1\" start=\"6\" type=\"BEAT\"/></bml>");
        this.parser.addBehaviourBlock(bb);
        Assert.assertTrue((boolean)this.parser.directGround("bml1", "g1"));
    }

    @Test
    public void testNotDirectGrounded() {
        BehaviourBlock bb = new BehaviourBlock(new BMLBehaviorAttributeExtension[0]);
        bb.readXML("<bml id=\"bml1\"><gesture id=\"g1\" start=\"g2:start\" type=\"BEAT\"/><gesture id=\"g2\" type=\"BEAT\"/></bml>");
        this.parser.addBehaviourBlock(bb);
        Assert.assertFalse((boolean)this.parser.directGround("bml1", "g1"));
    }

    @Test
    public void testGetUngroundedLoops() {
        BehaviourBlock bb = new BehaviourBlock(new BMLBehaviorAttributeExtension[0]);
        bb.readXML("<bml id=\"bml1\"><gesture id=\"g1\" start=\"g2:start\" end=\"g2:end\" type=\"BEAT\"/><gesture id=\"g2\" type=\"BEAT\"/></bml>");
        this.parser.addBehaviourBlock(bb);
        List<List<Behaviour>> list = this.parser.getUngroundedLoops("bml1", "g1");
        Assert.assertEquals((long)1L, (long)list.size());
        MatcherAssert.assertThat(list.get(0), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Behaviour[]{this.parser.getBehaviour("bml1", "g2")}));
    }

    @Test
    public void testGetUngroundedLoops2() {
        BehaviourBlock bb = new BehaviourBlock(new BMLBehaviorAttributeExtension[0]);
        bb.readXML("<bml id=\"bml1\"><gesture id=\"g1\" start=\"g2:start\" type=\"BEAT\"/><gesture id=\"g2\" type=\"BEAT\" end=\"g3:end\"/><gesture id=\"g3\" stroke=\"g1:stroke\" type=\"BEAT\"/></bml>");
        this.parser.addBehaviourBlock(bb);
        List<List<Behaviour>> list = this.parser.getUngroundedLoops("bml1", "g1");
        Assert.assertEquals((long)1L, (long)list.size());
        MatcherAssert.assertThat(list.get(0), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Behaviour[]{this.parser.getBehaviour("bml1", "g2"), this.parser.getBehaviour("bml1", "g3")}));
        list = this.parser.getUngroundedLoops("bml1", "g2");
        Assert.assertEquals((long)1L, (long)list.size());
        MatcherAssert.assertThat(list.get(0), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Behaviour[]{this.parser.getBehaviour("bml1", "g1"), this.parser.getBehaviour("bml1", "g3")}));
        list = this.parser.getUngroundedLoops("bml1", "g3");
        Assert.assertEquals((long)1L, (long)list.size());
        MatcherAssert.assertThat(list.get(0), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Behaviour[]{this.parser.getBehaviour("bml1", "g1"), this.parser.getBehaviour("bml1", "g2")}));
    }

    @Test
    public void testGetNoUngroundedLoopsWhenGrounded() {
        BehaviourBlock bb = new BehaviourBlock(new BMLBehaviorAttributeExtension[0]);
        bb.readXML("<bml id=\"bml1\"><gesture id=\"g1\" start=\"g2:start\" type=\"BEAT\"/><gesture start=\"1\" id=\"g2\" type=\"BEAT\" end=\"g3:end\"/><gesture id=\"g3\" stroke=\"g1:stroke\" type=\"BEAT\"/></bml>");
        this.parser.addBehaviourBlock(bb);
        List<List<Behaviour>> list = this.parser.getUngroundedLoops("bml1", "g1");
        Assert.assertEquals((long)0L, (long)list.size());
        list = this.parser.getUngroundedLoops("bml1", "g2");
        Assert.assertEquals((long)0L, (long)list.size());
        list = this.parser.getUngroundedLoops("bml1", "g3");
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testGetNoUngroundedLoopsWhenGrounded2() {
        BehaviourBlock bb = new BehaviourBlock(new BMLBehaviorAttributeExtension[0]);
        bb.readXML("<bml id=\"bml1\"><gesture id=\"g1\" start=\"g2:start\" type=\"BEAT\"/><gesture stroke=\"1\" id=\"g2\" type=\"BEAT\" end=\"g3:end\"/><gesture id=\"g3\" stroke=\"g1:stroke\" type=\"BEAT\"/></bml>");
        this.parser.addBehaviourBlock(bb);
        List<List<Behaviour>> list = this.parser.getUngroundedLoops("bml1", "g1");
        Assert.assertEquals((long)0L, (long)list.size());
        list = this.parser.getUngroundedLoops("bml1", "g2");
        Assert.assertEquals((long)1L, (long)list.size());
        MatcherAssert.assertThat(list.get(0), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Behaviour[]{this.parser.getBehaviour("bml1", "g1"), this.parser.getBehaviour("bml1", "g3")}));
        list = this.parser.getUngroundedLoops("bml1", "g3");
        Assert.assertEquals((long)0L, (long)list.size());
    }
}

