/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import com.google.common.collect.ImmutableList;
import hmi.bml.core.Behaviour;
import hmi.bml.parser.SyncPoint;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class PostureBehaviour
extends Behaviour {
    private String part = "";
    private String stance = "";
    private String shape = "";
    private String target = null;
    private FaceDirection facing;
    private static final List<String> DEFAULT_SYNCS = ImmutableList.of((Object)"start", (Object)"ready", (Object)"relax", (Object)"end");
    private LeanDirection leaning;
    private static final String XMLTAG = "posture";

    @Override
    public void addDefaultSyncPoints() {
        for (String s : PostureBehaviour.getDefaultSyncPoints()) {
            this.addSyncPoint(new SyncPoint(this.bmlId, this.id, s));
        }
    }

    public static List<String> getDefaultSyncPoints() {
        return DEFAULT_SYNCS;
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("part")) {
            return this.part;
        }
        if (name.equals("stance")) {
            return this.stance;
        }
        if (name.equals("shape")) {
            return this.shape;
        }
        if (name.equals("target")) {
            return this.target;
        }
        if (name.equals("facing")) {
            return this.facing.toString();
        }
        if (name.equals("leaning")) {
            return this.leaning.toString();
        }
        return null;
    }

    @Override
    public float getFloatParameterValue(String name) {
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    @Override
    public boolean specifiesParameter(String name) {
        if (name.equals("part")) {
            return true;
        }
        if (name.equals("stance")) {
            return true;
        }
        if (name.equals("shape")) {
            return true;
        }
        if (name.equals("target")) {
            return true;
        }
        if (name.equals("facing")) {
            return true;
        }
        return name.equals("leaning");
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("part")) {
            return this.part.equals(value);
        }
        if (name.equals("stance")) {
            return this.stance.equals(value);
        }
        if (name.equals("shape")) {
            return this.shape.equals(value);
        }
        if (name.equals("facing")) {
            return this.facing.toString().equals(value);
        }
        if (name.equals("leaning")) {
            return this.leaning.toString().equals(value);
        }
        return false;
    }

    public PostureBehaviour(String bmlId, XMLTokenizer tokenizer) throws IOException {
        super(bmlId);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        PostureBehaviour.appendAttribute((StringBuilder)buf, (String)"part", (String)this.part);
        PostureBehaviour.appendAttribute((StringBuilder)buf, (String)"stance", (String)this.stance);
        PostureBehaviour.appendAttribute((StringBuilder)buf, (String)"shape", (String)this.shape);
        PostureBehaviour.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        PostureBehaviour.appendAttribute((StringBuilder)buf, (String)"facing", (String)this.facing.toString());
        PostureBehaviour.appendAttribute((StringBuilder)buf, (String)"leaning", (String)this.leaning.toString());
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.part = this.getOptionalAttribute("part", attrMap, "");
        this.stance = this.getRequiredAttribute("stance", attrMap, tokenizer);
        this.shape = this.getRequiredAttribute("shape", attrMap, tokenizer);
        this.target = this.getOptionalAttribute("target", attrMap, "");
        this.facing = FaceDirection.valueOf(this.getOptionalAttribute("facing", attrMap, FaceDirection.FRONT.toString()));
        this.leaning = LeanDirection.valueOf(this.getOptionalAttribute("leaning", attrMap, LeanDirection.NONE.toString()));
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    private static enum LeanDirection {
        NONE,
        UP,
        DOWN;

    }

    private static enum FaceDirection {
        LEFT,
        RIGHT,
        UP,
        DOWN,
        FRONT,
        BACK,
        UPRIGHT,
        UPLEFT,
        DOWNLEFT,
        DOWNRIGHT;

    }
}

