/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.core;

import hmi.bml.core.HeadDirectionShiftBehaviour;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class HeadDirectionShiftBehaviourTest {
    private static final double PARAMETER_PRECISION = 1.0E-4;

    @Test
    public void testReadXML() throws IOException {
        String str = "<headDirectionShift id=\"head1\" start=\"1\" target=\"bluebox\"/>";
        HeadDirectionShiftBehaviour beh = new HeadDirectionShiftBehaviour("bml1", new XMLTokenizer(str));
        Assert.assertEquals((Object)"head1", (Object)beh.id);
        Assert.assertEquals((Object)"bml1", (Object)beh.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)beh.getStringParameterValue("target"));
        Assert.assertEquals((double)1.0, (double)beh.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }

    @Test
    public void testWriteXML() throws IOException {
        String str = "<headDirectionShift id=\"head1\" start=\"1\" target=\"bluebox\"/>";
        HeadDirectionShiftBehaviour behIn = new HeadDirectionShiftBehaviour("bml1", new XMLTokenizer(str));
        StringBuilder buf = new StringBuilder();
        behIn.appendXML(buf);
        HeadDirectionShiftBehaviour behOut = new HeadDirectionShiftBehaviour("bml1", new XMLTokenizer(buf.toString()));
        Assert.assertEquals((Object)"head1", (Object)behOut.id);
        Assert.assertEquals((Object)"bml1", (Object)behOut.bmlId);
        Assert.assertEquals((Object)"bluebox", (Object)behOut.getStringParameterValue("target"));
        Assert.assertEquals((double)1.0, (double)behOut.getSyncPoints().get((int)0).getRef().offset, (double)1.0E-4);
    }
}

